/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.local;

import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.common.model.UnNamedModuleFixer;
import io.rxmicro.common.util.Formats;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.reflection.Reflections;
import java.util.ServiceLoader;

public final class UnNamedModuleFixers {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnNamedModuleFixers.class);

    public static void componentTestsFix() {
        UnNamedModuleFixers.testFix("$$ComponentTestFixer");
    }

    public static void restBasedMicroServiceTestsFix() {
        UnNamedModuleFixers.testFix("$$RestBasedMicroServiceTestFixer");
    }

    public static void integrationTestsFix() {
        UnNamedModuleFixers.testFix("$$IntegrationTestFixer");
    }

    private static void testFix(String testFixSimpleClassName) {
        block2: {
            try {
                Reflections.instantiate((String)Formats.format((String)"?.?", (Object[])new Object[]{"rxmicro", testFixSimpleClassName}), (Object[])new Object[0]);
            }
            catch (CheckedWrapperException ex) {
                if (ex.isCause(ClassNotFoundException.class)) break block2;
                LOGGER.error((Throwable)ex, "Can't instantiate a `?.?` class: ?", (Object)"rxmicro", (Object)testFixSimpleClassName, (Object)ex.getMessage());
            }
        }
        UnNamedModuleFixers.commonFix();
    }

    private static void commonFix() {
        Module unNamedModule = UnNamedModuleFixers.class.getClassLoader().getUnnamedModule();
        ServiceLoader<UnNamedModuleFixer> loader = ServiceLoader.load(UnNamedModuleFixer.class);
        for (UnNamedModuleFixer namedModule : loader) {
            namedModule.fix(unNamedModule);
        }
    }

    private UnNamedModuleFixers() {
    }
}

