/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.json.internal;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Formats;
import io.rxmicro.json.JsonNumber;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public final class JsonConverter {
    public static Object convertIfNecessary(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return JsonConverter.getJsonObject(value);
        }
        if (value instanceof Iterable) {
            return JsonConverter.getJsonArray(value);
        }
        if (value.getClass().isArray()) {
            throw new IllegalArgumentException("Java array is not valid json object value! Use jsonArray() factory method instead!");
        }
        return JsonConverter.getJsonPrimitive(value);
    }

    private static Object getJsonPrimitive(Object value) {
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof JsonNumber) {
            return value;
        }
        if (value instanceof Number) {
            return JsonConverter.getJsonNumber(value);
        }
        return value.toString();
    }

    private static Object getJsonNumber(Object value) {
        if (value instanceof BigDecimal) {
            return new JsonNumber(((BigDecimal)value).toPlainString());
        }
        return new JsonNumber(value.toString());
    }

    private static Object getJsonObject(Object value) {
        if (ExCollections.isUnmodifiableMap((Object)value)) {
            JsonConverter.validateJsonObject((Map)value);
            return value;
        }
        throw new IllegalArgumentException("Map is not valid json object value! Use jsonObject() factory method instead!");
    }

    private static Object getJsonArray(Object value) {
        if (ExCollections.isUnmodifiableList((Object)value)) {
            JsonConverter.validateJsonArray((List)value);
            return value;
        }
        throw new IllegalArgumentException("Iterable is not valid json object value! Use jsonArray() factory method instead!");
    }

    private static void validateJsonArray(List<?> value) {
        for (Object o : value) {
            JsonConverter.validateJsonItem(o);
        }
    }

    private static void validateJsonObject(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            JsonConverter.validateJsonItem(entry.getValue());
        }
    }

    private static void validateJsonItem(Object object) {
        if (object instanceof List) {
            JsonConverter.validateJsonArray((List)object);
        } else if (object instanceof Map) {
            JsonConverter.validateJsonObject((Map)object);
        } else {
            JsonConverter.validatePrimitive(object);
        }
    }

    private static void validatePrimitive(Object object) {
        if (object instanceof JsonNumber || object instanceof Boolean || object instanceof String || object == null) {
            return;
        }
        throw new IllegalArgumentException(Formats.format((String)"'?' class is not valid JSON primitive. Use jsonObject() or jsonArray() factory methods instead!", (Object[])new Object[]{object.getClass().getName()}));
    }

    private JsonConverter() {
    }
}

