/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal.validator;

import io.rxmicro.common.local.DeniedPackages;
import io.rxmicro.common.util.Formats;
import io.rxmicro.test.local.InvalidTestConfigException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class FieldValidator {
    public void validate(List<Field> fields) {
        for (Field field : fields) {
            this.validate(field);
        }
    }

    protected abstract void validate(Field var1);

    protected final String fieldNamePrefix(Field field) {
        return Formats.format((String)"'?.?' field", (Object[])new Object[]{field.getDeclaringClass().getSimpleName(), field.getName()});
    }

    protected final void validateThatFieldIsNotFinal(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new InvalidTestConfigException("? could not be a final. Remove 'final' modifier!", this.fieldNamePrefix(field));
        }
    }

    protected final void validateThatFieldIsNotStatic(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new InvalidTestConfigException("? could not be a static! Remove 'static' modifier!", this.fieldNamePrefix(field));
        }
    }

    protected final void validateThatFieldWithGivenTypeIsSinglePerClass(List<Field> fields, Class<?> verifiedType) {
        if (fields.size() > 1) {
            throw new InvalidTestConfigException("? is redundant, because it is expected only one field with '?' type per test class. Remove this field!", this.fieldNamePrefix(fields.get(fields.size() - 1)), verifiedType.getName());
        }
    }

    protected final void validateThatFieldWithGivenTypeIsSinglePerClass(List<Field> fields) {
        HashMap<Class, List> map = new HashMap<Class, List>();
        for (Field field : fields) {
            map.computeIfAbsent(field.getType(), v -> new ArrayList()).add(field);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            throw new InvalidTestConfigException("? is redundant, because it is expected only one field with '?' type per test class. Remove this field!", this.fieldNamePrefix((Field)((List)entry.getValue()).get(((List)entry.getValue()).size() - 1)), ((Class)entry.getKey()).getName());
        }
    }

    @SafeVarargs
    protected final void validateThatFieldIsAnnotatedOnlyBySupportedOnes(Field field, Class<? extends Annotation> ... supportedAnnotations) {
        Set<Class<? extends Annotation>> supportedAnnotationSet = Set.of(supportedAnnotations);
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationClass = annotation.annotationType();
            if (!DeniedPackages.isDeniedPackage((String)annotationClass.getPackageName()) || annotationClass.getPackageName().startsWith("org.mockito") || supportedAnnotationSet.contains(annotationClass)) continue;
            throw new InvalidTestConfigException("? is annotated by unsupported '@?' annotation. Remove the '@?' annotation!", this.fieldNamePrefix(field), annotationClass.getName(), annotationClass.getName());
        }
    }

    protected final void validateThatFieldAnnotatedByRequiredAnnotation(Field field, Class<? extends Annotation> annotationClass) {
        if (!field.isAnnotationPresent(annotationClass)) {
            throw new InvalidTestConfigException("? is not annotated by required '@?' annotation. Add the missing annotation!", this.fieldNamePrefix(field), annotationClass.getName());
        }
    }
}

