/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal.http;

import io.rxmicro.common.InvalidStateException;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.http.HttpVersion;
import io.rxmicro.test.ClientHttpResponse;
import io.rxmicro.test.internal.http.JdkHttpHeaders;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.function.Function;

final class JdkHttpResponse
implements ClientHttpResponse {
    private final HttpResponse<byte[]> response;
    private final Function<byte[], Object> responseBodyConverter;
    private JdkHttpHeaders jdkHttpHeaders;

    JdkHttpResponse(HttpResponse<byte[]> response, Function<byte[], Object> responseBodyConverter) {
        this.response = response;
        this.responseBodyConverter = responseBodyConverter;
    }

    @Override
    public int getStatusCode() {
        return this.response.statusCode();
    }

    @Override
    public HttpVersion getVersion() {
        if (this.response.version() == HttpClient.Version.HTTP_1_1) {
            return HttpVersion.HTTP_1_1;
        }
        if (this.response.version() == HttpClient.Version.HTTP_2) {
            return HttpVersion.HTTP_2;
        }
        throw new InvalidStateException("Unsupported HTTP version: ?", new Object[]{this.response.version()});
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.jdkHttpHeaders == null) {
            this.jdkHttpHeaders = new JdkHttpHeaders(this.response.headers());
        }
        return this.jdkHttpHeaders;
    }

    @Override
    public boolean isBodyEmpty() {
        return this.response.body().length == 0;
    }

    @Override
    public Object getBody() {
        return this.responseBodyConverter.apply(this.response.body());
    }

    @Override
    public byte[] getBodyAsBytes() {
        return this.response.body();
    }
}

