/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal.http;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.http.local.AbstractHttpHeaders;
import java.net.http.HttpHeaders;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class JdkHttpHeaders
extends AbstractHttpHeaders {
    private final HttpHeaders httpHeaders;

    JdkHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public String getValue(String name) {
        List<String> values = this.httpHeaders.map().get(name);
        return values == null || values.isEmpty() ? null : values.get(0);
    }

    public List<String> getValues(String name) {
        return this.httpHeaders.allValues(name);
    }

    public boolean contains(String name) {
        return this.httpHeaders.map().containsKey(name);
    }

    public List<Map.Entry<String, String>> getEntries() {
        return ExCollections.unmodifiableList((Collection)this.httpHeaders.map().entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> Map.entry((String)e.getKey(), v))).collect(Collectors.toList()));
    }

    public int size() {
        return this.httpHeaders.map().size();
    }

    public boolean isNotEmpty() {
        return !this.httpHeaders.map().isEmpty();
    }
}

