/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal.http;

import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.common.util.Strings;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.http.HttpHeaders;
import io.rxmicro.rest.BaseUrlPath;
import io.rxmicro.rest.Version;
import io.rxmicro.rest.client.detail.HttpClientContentConverter;
import io.rxmicro.runtime.detail.RxMicroRuntime;
import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.ClientHttpResponse;
import io.rxmicro.test.internal.http.JdkHttpResponse;
import io.rxmicro.test.local.BlockingHttpClientConfig;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;

public final class JdkBlockingHttpClient
implements BlockingHttpClient {
    private final BlockingHttpClientConfig config;
    private final HttpClient client;
    private final Function<Object, byte[]> requestBodyConverter;
    private final Function<byte[], Object> responseBodyConverter;
    private final Map.Entry<String, String> acceptHeader;
    private final Map.Entry<String, String> contentTypeHeader;
    private final Map.Entry<String, String> userAgentHeader;
    private final Map.Entry<String, String> versionHeader;
    private final String baseUrlPath;

    private JdkBlockingHttpClient(BlockingHttpClientConfig config, HttpClientContentConverter contentConverter, String baseUrlPath, BaseUrlPath.Position baseUrlPosition, String versionValue, Version.Strategy versionStrategy) {
        this.config = config;
        String contentType = (String)Requires.require((Object)contentConverter.getContentType());
        this.acceptHeader = Map.entry("Accept", contentType);
        this.contentTypeHeader = Map.entry("Content-Type", contentType);
        this.userAgentHeader = Map.entry("User-Agent", Formats.format((String)"?-test-jdk-http-client/?", (Object[])new Object[]{"rx-micro", RxMicroRuntime.getRxMicroVersion()}));
        ArrayList<String> baseUrlFragments = new ArrayList<String>();
        if (baseUrlPath != null) {
            baseUrlFragments.add(baseUrlPath);
        }
        if (versionStrategy == Version.Strategy.URL_PATH) {
            if (baseUrlPath != null) {
                int index = baseUrlPosition == BaseUrlPath.Position.BEFORE_VERSION ? 1 : 0;
                baseUrlFragments.add(index, versionValue);
            } else {
                baseUrlFragments.add(versionValue);
            }
            this.versionHeader = null;
        } else {
            this.versionHeader = Optional.ofNullable(versionValue).map(v -> Map.entry("Api-Version", v)).orElse(null);
        }
        this.baseUrlPath = baseUrlFragments.isEmpty() ? null : String.join((CharSequence)"", baseUrlFragments);
        this.requestBodyConverter = (Function)Requires.require((Object)contentConverter.getRequestContentConverter());
        this.responseBodyConverter = (Function)Requires.require((Object)contentConverter.getResponseContentConverter());
        this.client = HttpClient.newBuilder().followRedirects(config.isFollowRedirects() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER).build();
    }

    @Override
    public ClientHttpResponse send(String method, String path, HttpHeaders headers) {
        HttpRequest request = this.newRequestBuilder(this.getValidPath(path), this.nonNull(headers, "headers").getEntries(), false).method(this.nonNull(method, "method"), HttpRequest.BodyPublishers.noBody()).build();
        return this.sendRequest(request);
    }

    @Override
    public ClientHttpResponse send(String method, String path, HttpHeaders headers, Object body) {
        this.validateThatPathNotContainsQueryParams(path);
        byte[] requestBody = this.requestBodyConverter.apply(this.nonNull(body, "body"));
        HttpRequest request = this.newRequestBuilder(this.getValidPath(path), this.nonNull(headers, "headers").getEntries(), true).method(this.nonNull(method, "method"), HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
        return this.sendRequest(request);
    }

    private String getValidPath(String path) {
        String normalizeUrlPath = UrlPaths.normalizeUrlPath((String)this.nonNull(path, "path"));
        if (this.baseUrlPath != null && !normalizeUrlPath.startsWith(this.baseUrlPath)) {
            return this.baseUrlPath + normalizeUrlPath;
        }
        return normalizeUrlPath;
    }

    private HttpRequest.Builder newRequestBuilder(String path, List<Map.Entry<String, String>> headers, boolean withBody) {
        HttpRequest.Builder requestBuilder = Strings.startsWith((String)path, (char)'/') ? HttpRequest.newBuilder().uri(URI.create(this.config.getConnectionString() + path)) : HttpRequest.newBuilder().uri(URI.create(this.config.getConnectionString() + "/" + path));
        this.setHeaders(requestBuilder, headers, withBody);
        if (!this.config.getRequestTimeout().isZero()) {
            requestBuilder.timeout(this.config.getRequestTimeout());
        }
        requestBuilder.version(HttpClient.Version.HTTP_1_1);
        return requestBuilder;
    }

    private void setHeaders(HttpRequest.Builder requestBuilder, List<Map.Entry<String, String>> headers, boolean withBody) {
        TreeSet addedHeaders = headers.isEmpty() ? Set.of() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        headers.forEach(e -> {
            addedHeaders.add((String)e.getKey());
            requestBuilder.header((String)e.getKey(), (String)e.getValue());
        });
        if (!addedHeaders.contains(this.acceptHeader.getKey())) {
            requestBuilder.header(this.acceptHeader.getKey(), this.acceptHeader.getValue());
        }
        if (withBody && !addedHeaders.contains(this.contentTypeHeader.getKey())) {
            requestBuilder.header(this.contentTypeHeader.getKey(), this.contentTypeHeader.getValue());
        }
        if (!addedHeaders.contains(this.userAgentHeader.getKey())) {
            requestBuilder.header(this.userAgentHeader.getKey(), this.userAgentHeader.getValue());
        }
        if (this.versionHeader != null && !addedHeaders.contains(this.versionHeader.getKey())) {
            requestBuilder.header(this.versionHeader.getKey(), this.versionHeader.getValue());
        }
    }

    private ClientHttpResponse sendRequest(HttpRequest request) {
        return new JdkHttpResponse(this.client.sendAsync(request, responseInfo -> HttpResponse.BodySubscribers.ofByteArray()).join(), this.responseBodyConverter);
    }

    private void validateThatPathNotContainsQueryParams(String path) {
        if (this.nonNull(path, "path").indexOf(63) != -1) {
            throw new IllegalArgumentException("Query params not supported here. Use HTTP body instead!");
        }
    }

    private <T> T nonNull(T object, String name) {
        return (T)Requires.require(object, (String)Formats.format((String)"'?' couldn't be null", (Object[])new Object[]{name}), (Supplier[])new Supplier[0]);
    }

    public void release() {
    }

    public static final class Builder {
        private BlockingHttpClientConfig blockingHttpClientConfig;
        private HttpClientContentConverter contentConverter;
        private String versionValue;
        private Version.Strategy versionStrategy;
        private String baseUrlPath;
        private BaseUrlPath.Position baseUrlPosition;

        public Builder setBlockingHttpClientConfig(BlockingHttpClientConfig blockingHttpClientConfig) {
            this.blockingHttpClientConfig = (BlockingHttpClientConfig)((Object)Requires.require((Object)((Object)blockingHttpClientConfig)));
            return this;
        }

        public Builder setContentConverter(HttpClientContentConverter contentConverter) {
            this.contentConverter = (HttpClientContentConverter)Requires.require((Object)contentConverter);
            return this;
        }

        public Builder setVersion(Version.Strategy versionStrategy, String versionValue) {
            this.versionStrategy = (Version.Strategy)Requires.require((Object)versionStrategy);
            this.versionValue = versionStrategy == Version.Strategy.URL_PATH ? UrlPaths.normalizeUrlPath((String)versionValue) : (String)Requires.require((Object)versionValue);
            return this;
        }

        public Builder setBaseUrl(String baseUrlPath, BaseUrlPath.Position baseUrlPosition) {
            this.baseUrlPath = UrlPaths.normalizeUrlPath((String)baseUrlPath);
            this.baseUrlPosition = (BaseUrlPath.Position)Requires.require((Object)baseUrlPosition);
            return this;
        }

        public JdkBlockingHttpClient build() {
            return new JdkBlockingHttpClient(this.blockingHttpClientConfig, this.contentConverter, this.baseUrlPath, this.baseUrlPosition, this.versionValue, this.versionStrategy);
        }
    }
}

