/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal;

import io.rxmicro.common.CheckedWrapperException;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;

public final class TestedProcessProxy
extends Process {
    private final Process process;
    private final Thread outputCatcher;
    private final CompletableFuture<Process> onExitCompletableFuture;

    public TestedProcessProxy(Process processWithRedirectedErrorStream) {
        this.process = (Process)Requires.require((Object)processWithRedirectedErrorStream);
        this.outputCatcher = new Thread((Runnable)new ProcessOutputCatcher(processWithRedirectedErrorStream), "Process output catcher for pid=" + this.process.pid());
        this.outputCatcher.start();
        this.onExitCompletableFuture = this.process.onExit().thenApply(this.interruptOutputCatcherAfterProcessExit());
    }

    private Function<Process, Process> interruptOutputCatcherAfterProcessExit() {
        return process -> {
            this.interruptOutputCatcher(true);
            return process;
        };
    }

    @Override
    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("Input stream is redirected to System.out, so this method can't be used!");
    }

    @Override
    public InputStream getErrorStream() {
        throw new UnsupportedOperationException("Error stream is redirected to System.out, so this method can't be used!");
    }

    @Override
    public int waitFor() throws InterruptedException {
        int exitValue = this.process.waitFor();
        this.interruptOutputCatcher(true);
        return exitValue;
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        boolean isProcessTerminated = this.process.waitFor(timeout, unit);
        if (isProcessTerminated) {
            this.interruptOutputCatcher(true);
        }
        return isProcessTerminated;
    }

    @Override
    public int exitValue() {
        return this.process.exitValue();
    }

    @Override
    public void destroy() {
        this.interruptOutputCatcher(false);
        this.process.destroy();
        this.waitForOutputCatcherTerminated();
    }

    @Override
    public Process destroyForcibly() {
        this.interruptOutputCatcher(false);
        this.process.destroyForcibly();
        this.waitForOutputCatcherTerminated();
        return this;
    }

    @Override
    public boolean supportsNormalTermination() {
        return this.process.supportsNormalTermination();
    }

    @Override
    public boolean isAlive() {
        return this.process.isAlive();
    }

    @Override
    public long pid() {
        return this.process.pid();
    }

    @Override
    public CompletableFuture<Process> onExit() {
        return this.onExitCompletableFuture;
    }

    @Override
    public ProcessHandle toHandle() {
        return this.process.toHandle();
    }

    @Override
    public ProcessHandle.Info info() {
        return this.process.info();
    }

    @Override
    public Stream<ProcessHandle> children() {
        return this.process.children();
    }

    @Override
    public Stream<ProcessHandle> descendants() {
        return this.process.descendants();
    }

    private void interruptOutputCatcher(boolean waitForOutputCatcherTerminated) {
        if (this.outputCatcher.isAlive()) {
            this.outputCatcher.interrupt();
            if (waitForOutputCatcherTerminated) {
                this.waitForOutputCatcherTerminated();
            }
        }
    }

    private void waitForOutputCatcherTerminated() {
        try {
            this.outputCatcher.join();
        }
        catch (InterruptedException ex) {
            throw new CheckedWrapperException((Throwable)ex);
        }
    }

    private static final class ProcessOutputCatcher
    implements Runnable {
        private final Process process;

        private ProcessOutputCatcher(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try (InputStream inputStream = this.process.getInputStream();){
                inputStream.transferTo(System.out);
            }
            catch (Throwable throwable) {
                System.out.println(Formats.format((String)"Can't display process output: process=`?`, message=?", (Object[])new Object[]{this.processInfoToString(this.process), throwable.getMessage()}));
                throwable.printStackTrace(System.out);
            }
        }

        private String processInfoToString(Process process) {
            StringBuilder stringBuilder = new StringBuilder().append(Formats.format((String)"[PID=?]", (Object[])new Object[]{process.pid()}));
            ProcessHandle.Info info = process.info();
            info.user().ifPresent(user -> stringBuilder.append(Formats.format((String)" {USER='?'}", (Object[])new Object[]{user})));
            info.command().ifPresent(command -> stringBuilder.append(' ').append((String)command));
            info.arguments().ifPresent(args -> stringBuilder.append(' ').append(String.join((CharSequence)" ", args)));
            return stringBuilder.toString();
        }
    }
}

