/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal;

import io.rxmicro.test.SystemErr;
import io.rxmicro.test.SystemOut;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;

public final class SystemStreamImpl
implements SystemOut,
SystemErr {
    private final SpyOutputStream spyOutputStream;

    public SystemStreamImpl(PrintStream originalStdout) {
        this.spyOutputStream = new SpyOutputStream(originalStdout);
    }

    public PrintStream getPrintStream() {
        return new PrintStream((OutputStream)this.spyOutputStream, false, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] asBytes() {
        return this.spyOutputStream.byteArrayOutputStream.toByteArray();
    }

    private static final class SpyOutputStream
    extends FilterOutputStream {
        private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();

        private SpyOutputStream(PrintStream originalStdout) {
            super(originalStdout);
        }

        @Override
        public void write(int byteValue) throws IOException {
            super.write(byteValue);
            this.byteArrayOutputStream.write(byteValue);
        }
    }
}

