/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public interface SystemStream {
    public byte[] asBytes();

    default public String asString() {
        return this.asString(StandardCharsets.UTF_8, true);
    }

    default public String asString(boolean trim) {
        return this.asString(StandardCharsets.UTF_8, trim);
    }

    default public String asString(Charset charset) {
        return this.asString(charset, true);
    }

    default public String asString(Charset charset, boolean trim) {
        String string = new String(this.asBytes(), charset);
        return trim ? string.trim() : string;
    }

    default public List<String> asStrings() {
        return this.asStrings(StandardCharsets.UTF_8, true);
    }

    default public List<String> asStrings(boolean trim) {
        return this.asStrings(StandardCharsets.UTF_8, trim);
    }

    default public List<String> asStrings(Charset charset) {
        return this.asStrings(charset, true);
    }

    default public List<String> asStrings(Charset charset, boolean trim) {
        return Arrays.stream(this.asString(charset, trim).split(System.lineSeparator())).map(s -> trim ? s.trim() : s).collect(Collectors.toList());
    }

    default public boolean isEmpty() {
        return this.asBytes().length == 0;
    }
}

