/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal;

import com.mongodb.reactivestreams.client.MongoDatabase;
import io.r2dbc.pool.ConnectionPool;
import io.rxmicro.cdi.detail.BeanSupplier;
import io.rxmicro.config.Config;
import io.rxmicro.data.mongo.detail.AbstractMongoRepository;
import io.rxmicro.data.sql.r2dbc.postgresql.detail.AbstractPostgreSQLRepository;
import io.rxmicro.rest.client.detail.AbstractRestClient;
import io.rxmicro.rest.client.detail.HttpClientFactory;
import io.rxmicro.test.BlockingHttpClient;
import io.rxmicro.test.SystemErr;
import io.rxmicro.test.SystemOut;
import io.rxmicro.test.local.util.GeneratedClasses;

public final class DetectTypeRules {
    public static boolean isConfig(Class<?> type) {
        return Config.class.isAssignableFrom(type);
    }

    public static boolean isBlockingHttpClient(Class<?> type) {
        return BlockingHttpClient.class == type;
    }

    public static boolean isSystemOut(Class<?> type) {
        return SystemOut.class == type;
    }

    public static boolean isSystemErr(Class<?> type) {
        return SystemErr.class == type;
    }

    public static boolean isMongoDatabase(Class<?> type) {
        return MongoDatabase.class == type;
    }

    public static boolean isSqlConnectionPool(Class<?> type) {
        return ConnectionPool.class == type;
    }

    public static boolean isHttpClientFactory(Class<?> type) {
        return HttpClientFactory.class == type;
    }

    public static boolean isRepositoryField(Class<?> type) {
        return DetectTypeRules.isMongoRepositoryField(type) || DetectTypeRules.isPostgreRepositoryField(type);
    }

    public static boolean isMongoRepositoryField(Class<?> type) {
        return GeneratedClasses.isClassGenerated(type, "?.$$Mongo?", AbstractMongoRepository.class);
    }

    public static boolean isPostgreRepositoryField(Class<?> type) {
        return GeneratedClasses.isClassGenerated(type, "?.$$PostgreSQL?", AbstractPostgreSQLRepository.class);
    }

    public static boolean isBeanField(Class<?> type) {
        return GeneratedClasses.isClassGenerated(type, "?.$$?BeanSupplier", BeanSupplier.class);
    }

    public static boolean isRestClientField(Class<?> type) {
        return GeneratedClasses.isClassGenerated(type, "?.$$?", AbstractRestClient.class);
    }

    private DetectTypeRules() {
    }
}

