/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test.internal;

import io.rxmicro.common.util.Requires;
import io.rxmicro.reflection.Reflections;
import io.rxmicro.test.Alternative;
import io.rxmicro.test.local.InvalidTestConfigException;
import io.rxmicro.test.local.util.FieldNames;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class AlternativeEntryPoint {
    private final Alternative alternative;
    private final Field testClassField;
    private Object value;

    public AlternativeEntryPoint(Alternative alternative, Field testClassField) {
        this.alternative = (Alternative)Requires.require((Object)alternative);
        this.testClassField = (Field)Requires.require((Object)testClassField);
    }

    public Class<?> getFieldType() {
        return this.testClassField.getType();
    }

    public String getHumanReadableErrorName() {
        return FieldNames.getHumanReadableFieldName(this.testClassField);
    }

    public void readValue(List<Object> testInstances) {
        this.value = Reflections.getFieldValue(testInstances, (Field)this.testClassField);
        if (this.value == null && !this.alternative.expectNull()) {
            throw new InvalidTestConfigException("Alternative couldn't be null: '?.?'", this.testClassField.getDeclaringClass().getSimpleName(), this.testClassField.getName());
        }
    }

    public String getInjectionName() {
        return Optional.of(this.alternative).map(Alternative::name).filter(v -> !v.isEmpty()).orElse(this.testClassField.getName());
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.testClassField);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AlternativeEntryPoint that = (AlternativeEntryPoint)other;
        return this.testClassField.equals(that.testClassField);
    }

    public String toString() {
        return "AlternativeEntryPoint{alternative=" + this.alternative + ", testClassField=" + this.testClassField + ", value=" + this.value + "}";
    }
}

