/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.test;

import io.rxmicro.common.util.Requires;
import io.rxmicro.test.internal.TestedProcessProxy;
import java.io.File;
import java.io.IOException;

public final class TestedProcessBuilder {
    private String[] commandWithArgs;
    private File workingDir;
    private boolean redirectStdOutAndStdErrToSysOut = true;

    public TestedProcessBuilder setCommandWithArgs(String ... commandWithArgs) {
        this.commandWithArgs = (String[])Requires.require((Object)commandWithArgs);
        return this;
    }

    public TestedProcessBuilder setWorkingDir(File workingDir) {
        this.workingDir = (File)Requires.require((Object)workingDir);
        return this;
    }

    public TestedProcessBuilder setRedirectStdOutAndStdErrToSysOut(boolean redirectStdOutAndStdErrToSysOut) {
        this.redirectStdOutAndStdErrToSysOut = redirectStdOutAndStdErrToSysOut;
        return this;
    }

    public Process start() throws IOException {
        if (this.redirectStdOutAndStdErrToSysOut) {
            return new TestedProcessProxy(new ProcessBuilder(this.commandWithArgs).directory(this.workingDir).redirectErrorStream(true).start());
        }
        return new ProcessBuilder(this.commandWithArgs).directory(this.workingDir).start();
    }
}

