/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.rest.server.exchange.json.internal;

import io.rxmicro.config.Configs;
import io.rxmicro.http.error.HttpErrorException;
import io.rxmicro.json.JsonException;
import io.rxmicro.json.JsonHelper;
import io.rxmicro.json.JsonTypes;
import io.rxmicro.rest.model.HttpCallFailedException;
import io.rxmicro.rest.server.RestServerConfig;
import io.rxmicro.rest.server.detail.component.HttpResponseBuilder;
import io.rxmicro.rest.server.detail.model.HttpResponse;
import io.rxmicro.rest.server.local.component.HttpErrorResponseBodyBuilder;
import java.util.Map;

public final class JsonHttpErrorResponseBodyBuilder
implements HttpErrorResponseBodyBuilder {
    private final RestServerConfig restServerConfig = (RestServerConfig)Configs.getConfig(RestServerConfig.class);

    public HttpResponse build(HttpResponseBuilder httpResponseBuilder, int status, String message) {
        HttpResponse response = httpResponseBuilder.build();
        response.setStatus(status);
        response.setHeader("Content-Type", "application/json");
        response.setContent(this.createErrorJson(String.valueOf(message)));
        return response;
    }

    public HttpResponse build(HttpResponseBuilder httpResponseBuilder, HttpErrorException exception) {
        HttpResponse response = httpResponseBuilder.build();
        response.setStatus(exception.getStatusCode());
        if (exception.getMessage() != null) {
            response.setHeader("Content-Type", "application/json");
            response.setContent(this.createErrorJson(exception.getMessage()));
        }
        return response;
    }

    public HttpResponse build(HttpResponseBuilder httpResponseBuilder, HttpCallFailedException exception) {
        HttpResponse response = httpResponseBuilder.build(false);
        response.setStatus(exception.getStatusCode());
        response.setVersion(exception.getVersion());
        response.setOrAddHeaders(exception.getHeaders());
        if (exception.isBodyPresent()) {
            response.setContent(exception.getBody());
        }
        return response;
    }

    public boolean isRxMicroError(HttpCallFailedException exception) {
        String server = exception.getHeaders().getValue("Server");
        if (server != null && server.startsWith("rx-micro")) {
            return true;
        }
        if ("application/json".equals(exception.getHeaders().getValue("Content-Type"))) {
            try {
                Object json = JsonHelper.readJson((String)exception.getBodyAsString());
                if (JsonTypes.isJsonObject((Object)json)) {
                    Map jsonObject = JsonTypes.asJsonObject((Object)json);
                    return jsonObject.size() == 1 && jsonObject.containsKey("message");
                }
            }
            catch (JsonException | NumberFormatException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private String createErrorJson(String message) {
        return JsonHelper.toJsonString(Map.of("message", message), (boolean)this.restServerConfig.isHumanReadableOutput());
    }
}

