/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.objectweb.asm;

import paper.libs.org.objectweb.asm.Constants;

public abstract class AnnotationVisitor {
    protected final int api;
    protected AnnotationVisitor av;

    protected AnnotationVisitor(int api) {
        this(api, null);
    }

    protected AnnotationVisitor(int api, AnnotationVisitor annotationVisitor) {
        if (api != 589824 && api != 524288 && api != 458752 && api != 393216 && api != 327680 && api != 262144 && api != 0x10A0000) {
            throw new IllegalArgumentException("Unsupported api " + api);
        }
        if (api == 0x10A0000) {
            Constants.checkAsmExperimental(this);
        }
        this.api = api;
        this.av = annotationVisitor;
    }

    public void visit(String name2, Object value) {
        if (this.av != null) {
            this.av.visit(name2, value);
        }
    }

    public void visitEnum(String name2, String descriptor, String value) {
        if (this.av != null) {
            this.av.visitEnum(name2, descriptor, value);
        }
    }

    public AnnotationVisitor visitAnnotation(String name2, String descriptor) {
        if (this.av != null) {
            return this.av.visitAnnotation(name2, descriptor);
        }
        return null;
    }

    public AnnotationVisitor visitArray(String name2) {
        if (this.av != null) {
            return this.av.visitArray(name2);
        }
        return null;
    }

    public void visitEnd() {
        if (this.av != null) {
            this.av.visitEnd();
        }
    }
}

