/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jheaps.array;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Iterator;
import paper.libs.org.jheaps.AddressableHeap;
import paper.libs.org.jheaps.annotations.LinearTime;
import paper.libs.org.jheaps.array.AbstractArrayAddressableHeap;

public class DaryArrayAddressableHeap<K, V>
extends AbstractArrayAddressableHeap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_HEAP_CAPACITY = 16;
    protected int d;

    public DaryArrayAddressableHeap(int d) {
        this(d, null, 16);
    }

    public DaryArrayAddressableHeap(int d, int capacity) {
        this(d, null, capacity);
    }

    public DaryArrayAddressableHeap(int d, Comparator<? super K> comparator2) {
        this(d, comparator2, 16);
    }

    public DaryArrayAddressableHeap(int d, Comparator<? super K> comparator2, int capacity) {
        super(comparator2, capacity);
        if (d < 2) {
            throw new IllegalArgumentException("D-ary heaps must have at least 2 children per node");
        }
        this.d = d;
    }

    @LinearTime
    public static <K, V> DaryArrayAddressableHeap<K, V> heapify(int d, K[] keys, V[] values) {
        int i2;
        if (d < 2) {
            throw new IllegalArgumentException("D-ary heaps must have at least 2 children per node");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Key array cannot be null");
        }
        if (values != null && keys.length != values.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys.length == 0) {
            return new DaryArrayAddressableHeap<K, V>(d);
        }
        DaryArrayAddressableHeap<K, V> h = new DaryArrayAddressableHeap<K, V>(d, keys.length);
        for (i2 = 0; i2 < keys.length; ++i2) {
            K key = keys[i2];
            Object value = values == null ? null : (Object)values[i2];
            DaryArrayAddressableHeap<K, V> daryArrayAddressableHeap = h;
            daryArrayAddressableHeap.getClass();
            AbstractArrayAddressableHeap.ArrayHandle ah = daryArrayAddressableHeap.new AbstractArrayAddressableHeap.ArrayHandle(key, value);
            ah.index = i2 + 1;
            h.array[i2 + 1] = ah;
        }
        h.size = keys.length;
        for (i2 = keys.length / d; i2 > 0; --i2) {
            h.fixdown(i2);
        }
        return h;
    }

    @LinearTime
    public static <K, V> DaryArrayAddressableHeap<K, V> heapify(int d, K[] keys, V[] values, Comparator<? super K> comparator2) {
        int i2;
        if (d < 2) {
            throw new IllegalArgumentException("D-ary heaps must have at least 2 children per node");
        }
        if (keys == null) {
            throw new IllegalArgumentException("Keys array cannot be null");
        }
        if (values != null && keys.length != values.length) {
            throw new IllegalArgumentException("Values array must have the same length as the keys array");
        }
        if (keys.length == 0) {
            return new DaryArrayAddressableHeap<K, V>(d, comparator2);
        }
        DaryArrayAddressableHeap<K, V> h = new DaryArrayAddressableHeap<K, V>(d, comparator2, keys.length);
        for (i2 = 0; i2 < keys.length; ++i2) {
            K key = keys[i2];
            Object value = values == null ? null : (Object)values[i2];
            DaryArrayAddressableHeap<K, V> daryArrayAddressableHeap = h;
            daryArrayAddressableHeap.getClass();
            AbstractArrayAddressableHeap.ArrayHandle ah = daryArrayAddressableHeap.new AbstractArrayAddressableHeap.ArrayHandle(key, value);
            ah.index = i2 + 1;
            h.array[i2 + 1] = ah;
        }
        h.size = keys.length;
        for (i2 = keys.length / d; i2 > 0; --i2) {
            h.fixdownWithComparator(i2);
        }
        return h;
    }

    public Iterator<AddressableHeap.Handle<K, V>> handlesIterator() {
        return new Iterator<AddressableHeap.Handle<K, V>>(){
            private int pos = 1;

            @Override
            public boolean hasNext() {
                return this.pos <= DaryArrayAddressableHeap.this.size;
            }

            @Override
            public AddressableHeap.Handle<K, V> next() {
                return DaryArrayAddressableHeap.this.array[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void ensureCapacity(int capacity) {
        this.checkCapacity(capacity);
        AbstractArrayAddressableHeap.ArrayHandle[] newArray = (AbstractArrayAddressableHeap.ArrayHandle[])Array.newInstance(AbstractArrayAddressableHeap.ArrayHandle.class, capacity + 1);
        System.arraycopy(this.array, 1, newArray, 1, this.size);
        this.array = newArray;
    }

    @Override
    protected void forceFixup(int k) {
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (k > 1) {
            int p = (k - 2) / this.d + 1;
            this.array[k] = this.array[p];
            this.array[k].index = k;
            k = p;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixup(int k) {
        int p;
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (k > 1 && ((Comparable)this.array[p = (k - 2) / this.d + 1].getKey()).compareTo(h.getKey()) > 0) {
            this.array[k] = this.array[p];
            this.array[k].index = k;
            k = p;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixupWithComparator(int k) {
        int p;
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while (k > 1 && this.comparator.compare(this.array[p = (k - 2) / this.d + 1].getKey(), h.getKey()) > 0) {
            this.array[k] = this.array[p];
            this.array[k].index = k;
            k = p;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixdown(int k) {
        int c;
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while ((c = this.d * (k - 1) + 2) <= this.size) {
            int maxc = c;
            for (int i2 = 1; i2 < this.d && c + i2 <= this.size; ++i2) {
                if (((Comparable)this.array[maxc].getKey()).compareTo(this.array[c + i2].getKey()) <= 0) continue;
                maxc = c + i2;
            }
            if (((Comparable)h.getKey()).compareTo(this.array[maxc].getKey()) <= 0) break;
            this.array[k] = this.array[maxc];
            this.array[k].index = k;
            k = maxc;
        }
        this.array[k] = h;
        h.index = k;
    }

    @Override
    protected void fixdownWithComparator(int k) {
        int c;
        AbstractArrayAddressableHeap.ArrayHandle h = this.array[k];
        while ((c = this.d * (k - 1) + 2) <= this.size) {
            int maxc = c;
            for (int i2 = 1; i2 < this.d && c + i2 <= this.size; ++i2) {
                if (this.comparator.compare(this.array[maxc].getKey(), this.array[c + i2].getKey()) <= 0) continue;
                maxc = c + i2;
            }
            if (this.comparator.compare(h.getKey(), this.array[maxc].getKey()) <= 0) break;
            this.array[k] = this.array[maxc];
            this.array[k].index = k;
            k = maxc;
        }
        this.array[k] = h;
        h.index = k;
    }
}

