/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import paper.libs.org.jgrapht.util.CollectionUtil;

public class VertexToIntegerMapping<V> {
    private final Map<V, Integer> vertexMap;
    private final List<V> indexList;

    public VertexToIntegerMapping(Set<V> vertices) {
        Objects.requireNonNull(vertices, "the input collection of vertices cannot be null");
        this.vertexMap = CollectionUtil.newHashMapWithExpectedSize(vertices.size());
        this.indexList = new ArrayList<V>(vertices.size());
        for (V v : vertices) {
            this.vertexMap.put((Integer)v, this.vertexMap.size());
            this.indexList.add(v);
        }
    }

    public VertexToIntegerMapping(List<V> vertices) {
        Objects.requireNonNull(vertices, "the input collection of vertices cannot be null");
        this.vertexMap = CollectionUtil.newHashMapWithExpectedSize(vertices.size());
        this.indexList = vertices;
        for (int i2 = 0; i2 < vertices.size(); ++i2) {
            V v = vertices.get(i2);
            if (this.vertexMap.containsKey(v)) {
                throw new IllegalArgumentException("vertices are not distinct");
            }
            this.vertexMap.put((Integer)v, i2);
        }
    }

    public VertexToIntegerMapping(Collection<V> vertices) {
        Objects.requireNonNull(vertices, "the input collection of vertices cannot be null");
        this.vertexMap = CollectionUtil.newHashMapWithExpectedSize(vertices.size());
        this.indexList = new ArrayList<V>(vertices.size());
        for (V v : vertices) {
            if (!this.vertexMap.containsKey(v)) {
                this.vertexMap.put((Integer)v, this.vertexMap.size());
                this.indexList.add(v);
                continue;
            }
            throw new IllegalArgumentException("vertices are not distinct");
        }
    }

    public Map<V, Integer> getVertexMap() {
        return this.vertexMap;
    }

    public List<V> getIndexList() {
        return this.indexList;
    }
}

