/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.tour;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphPath;
import paper.libs.org.jgrapht.alg.tour.HamiltonianCycleAlgorithmBase;

public class NearestNeighborHeuristicTSP<V, E>
extends HamiltonianCycleAlgorithmBase<V, E> {
    private Random rng;
    private V first;

    public NearestNeighborHeuristicTSP() {
        this(null, new Random());
    }

    public NearestNeighborHeuristicTSP(V first) {
        this(Objects.requireNonNull(first, "Specified initial vertex cannot be null"), new Random());
    }

    public NearestNeighborHeuristicTSP(long seed) {
        this(null, new Random(seed));
    }

    public NearestNeighborHeuristicTSP(Random rng) {
        this(null, Objects.requireNonNull(rng, "Random number generator cannot be null"));
    }

    private NearestNeighborHeuristicTSP(V first, Random rng) {
        this.first = first;
        this.rng = rng;
    }

    @Override
    public GraphPath<V, E> getTour(Graph<V, E> graph) {
        this.checkGraph(graph);
        if (graph.vertexSet().size() == 1) {
            return this.getSingletonTour(graph);
        }
        HashSet<V> unvisited = new HashSet<V>(graph.vertexSet());
        V current = this.first(graph);
        unvisited.remove(current);
        ArrayList<V> visited = new ArrayList<V>(unvisited.size() + 1);
        visited.add(current);
        while (!unvisited.isEmpty()) {
            current = this.nearest(current, unvisited, graph);
            visited.add(current);
        }
        return this.vertexListToTour(visited, graph);
    }

    private V first(Graph<V, E> graph) {
        if (this.first == null) {
            this.first = graph.vertexSet().toArray()[this.rng.nextInt(graph.vertexSet().size())];
        } else if (!graph.vertexSet().contains(this.first)) {
            throw new IllegalArgumentException("Specified initial vertex is not in graph");
        }
        return this.first;
    }

    private V nearest(V current, Set<V> unvisited, Graph<V, E> graph) {
        Iterator<V> it = unvisited.iterator();
        V closest = it.next();
        double minDist = graph.getEdgeWeight(graph.getEdge(current, closest));
        while (it.hasNext()) {
            V v = it.next();
            double vDist = graph.getEdgeWeight(graph.getEdge(current, v));
            if (!(vDist < minDist)) continue;
            closest = v;
            minDist = vDist;
        }
        unvisited.remove(closest);
        return closest;
    }
}

