/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.util.Enumeration;
import paper.libs.org.eclipse.osgi.container.Module;
import paper.libs.org.eclipse.osgi.container.ModuleContainer;
import paper.libs.org.eclipse.osgi.framework.util.SecureAction;
import paper.libs.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import paper.libs.org.eclipse.osgi.storage.url.BundleResourceHandler;
import paper.libs.org.eclipse.osgi.storage.url.bundleresource.Handler;

public abstract class BundleFile {
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    protected File basefile;
    private int mruIndex = -1;

    protected BundleFile(File basefile) {
        this.basefile = basefile;
    }

    public abstract File getFile(String var1, boolean var2);

    public abstract BundleEntry getEntry(String var1);

    public Enumeration<String> getEntryPaths(String path) {
        return this.getEntryPaths(path, false);
    }

    public abstract Enumeration<String> getEntryPaths(String var1, boolean var2);

    public abstract void close() throws IOException;

    public abstract void open() throws IOException;

    public abstract boolean containsDir(String var1);

    public URL getResourceURL(String path, Module hostModule, int index) {
        BundleEntry bundleEntry = this.getEntry(path);
        if (bundleEntry == null) {
            return null;
        }
        return this.createResourceURL(bundleEntry, hostModule, index, path);
    }

    protected URL createResourceURL(BundleEntry bundleEntry, Module hostModule, int index, String path) {
        String protocol = "bundleresource";
        long bundleId = hostModule.getId();
        ModuleContainer container = hostModule.getContainer();
        Handler handler = new Handler(container, bundleEntry);
        return BundleFile.createURL(protocol, bundleId, container, bundleEntry, index, path, handler);
    }

    public File getBaseFile() {
        return this.basefile;
    }

    void setMruIndex(int index) {
        this.mruIndex = index;
    }

    int getMruIndex() {
        return this.mruIndex;
    }

    public String toString() {
        return String.valueOf(this.basefile);
    }

    public static URL createURL(String protocol, long bundleId, ModuleContainer container, BundleEntry entry, int index, String path, URLStreamHandler handler) {
        path = BundleFile.fixTrailingSlash(path, entry);
        try {
            String host = BundleResourceHandler.createURLHostForBundleID(container, bundleId);
            return secureAction.getURL(protocol, host, index, path, handler);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String fixTrailingSlash(String path, BundleEntry entry) {
        boolean entrySlash;
        String name2;
        if (path.length() == 0) {
            return "/";
        }
        if (path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        if ((name2 = entry.getName()).length() == 0) {
            return path;
        }
        boolean pathSlash = path.charAt(path.length() - 1) == '/';
        boolean bl = entrySlash = name2.length() > 0 && name2.charAt(name2.length() - 1) == '/';
        if (entrySlash != pathSlash) {
            path = entrySlash ? String.valueOf(path) + '/' : path.substring(0, path.length() - 1);
        }
        return path;
    }
}

