/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.serviceregistry;

import paper.libs.org.eclipse.osgi.internal.framework.BundleContextImpl;
import paper.libs.org.eclipse.osgi.internal.messages.Msg;
import paper.libs.org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import paper.libs.org.osgi.framework.ServiceException;

public class ServiceUse<S> {
    final ServiceRegistrationImpl<S> registration;
    private int useCount = 0;

    ServiceUse(BundleContextImpl context, ServiceRegistrationImpl<S> registration) {
        this.registration = registration;
    }

    S getService() {
        assert (Thread.holdsLock(this));
        this.incrementUse();
        return this.registration.getServiceObject();
    }

    boolean ungetService() {
        assert (Thread.holdsLock(this));
        if (!this.inUse()) {
            return false;
        }
        this.decrementUse();
        return true;
    }

    S getCachedService() {
        return this.registration.getServiceObject();
    }

    S newServiceObject() {
        return this.getService();
    }

    boolean releaseServiceObject(S service) {
        if (service == null || service != this.getCachedService()) {
            throw new IllegalArgumentException(Msg.SERVICE_OBJECTS_UNGET_ARGUMENT_EXCEPTION);
        }
        return this.ungetService();
    }

    void release() {
        assert (Thread.holdsLock(this));
        this.resetUse();
    }

    boolean isEmpty() {
        assert (Thread.holdsLock(this));
        return !this.inUse();
    }

    boolean inUse() {
        return this.useCount > 0;
    }

    void incrementUse() {
        if (this.useCount == Integer.MAX_VALUE) {
            throw new ServiceException(Msg.SERVICE_USE_OVERFLOW);
        }
        ++this.useCount;
    }

    void decrementUse() {
        assert (this.inUse());
        --this.useCount;
    }

    void resetUse() {
        this.useCount = 0;
    }
}

