/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.loader.sources;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import paper.libs.org.eclipse.osgi.internal.loader.BundleLoader;
import paper.libs.org.eclipse.osgi.internal.loader.sources.PackageSource;
import paper.libs.org.eclipse.osgi.internal.loader.sources.SingleSourcePackage;

public class MultiSourcePackage
extends PackageSource {
    private final SingleSourcePackage[] suppliers;

    public MultiSourcePackage(String id, SingleSourcePackage[] suppliers) {
        super(id);
        this.suppliers = suppliers;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return this.suppliers;
    }

    @Override
    public Class<?> loadClass(String name2) throws ClassNotFoundException {
        Class<?> result = null;
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage supplier = singleSourcePackageArray[n2];
            result = supplier.loadClass(name2);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public URL getResource(String name2) {
        URL result = null;
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage supplier = singleSourcePackageArray[n2];
            result = supplier.getResource(name2);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Enumeration<URL> getResources(String name2) {
        Enumeration<URL> results = null;
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage supplier = singleSourcePackageArray[n2];
            results = BundleLoader.compoundEnumerations(results, supplier.getResources(name2));
            ++n2;
        }
        return results;
    }

    @Override
    public Collection<String> listResources(String path, String filePattern) {
        ArrayList<String> result = new ArrayList<String>();
        SingleSourcePackage[] singleSourcePackageArray = this.suppliers;
        int n = this.suppliers.length;
        int n2 = 0;
        while (n2 < n) {
            SingleSourcePackage source = singleSourcePackageArray[n2];
            Collection<String> sourceResources = source.listResources(path, filePattern);
            for (String resource : sourceResources) {
                if (result.contains(resource)) continue;
                result.add(resource);
            }
            ++n2;
        }
        return result;
    }
}

