/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.framework;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import paper.libs.org.eclipse.osgi.container.ModuleCapability;
import paper.libs.org.eclipse.osgi.container.ModuleRequirement;
import paper.libs.org.eclipse.osgi.container.ModuleWire;
import paper.libs.org.eclipse.osgi.container.ModuleWiring;
import paper.libs.org.osgi.dto.DTO;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.InvalidSyntaxException;
import paper.libs.org.osgi.framework.ServiceReference;
import paper.libs.org.osgi.framework.Version;
import paper.libs.org.osgi.framework.dto.BundleDTO;
import paper.libs.org.osgi.framework.dto.FrameworkDTO;
import paper.libs.org.osgi.framework.dto.ServiceReferenceDTO;
import paper.libs.org.osgi.framework.startlevel.BundleStartLevel;
import paper.libs.org.osgi.framework.startlevel.FrameworkStartLevel;
import paper.libs.org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import paper.libs.org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import paper.libs.org.osgi.framework.wiring.BundleCapability;
import paper.libs.org.osgi.framework.wiring.BundleRequirement;
import paper.libs.org.osgi.framework.wiring.BundleRevision;
import paper.libs.org.osgi.framework.wiring.BundleRevisions;
import paper.libs.org.osgi.framework.wiring.BundleWiring;
import paper.libs.org.osgi.framework.wiring.dto.BundleRevisionDTO;
import paper.libs.org.osgi.framework.wiring.dto.BundleWireDTO;
import paper.libs.org.osgi.framework.wiring.dto.BundleWiringDTO;
import paper.libs.org.osgi.framework.wiring.dto.FrameworkWiringDTO;
import paper.libs.org.osgi.resource.dto.CapabilityDTO;
import paper.libs.org.osgi.resource.dto.CapabilityRefDTO;
import paper.libs.org.osgi.resource.dto.RequirementDTO;
import paper.libs.org.osgi.resource.dto.RequirementRefDTO;
import paper.libs.org.osgi.resource.dto.WireDTO;

public class DTOBuilder {
    private final Map<BundleRevision, BundleRevisionDTO> resources = new IdentityHashMap<BundleRevision, BundleRevisionDTO>();
    private final Map<BundleWiring, BundleWiringDTO.NodeDTO> wiringnodes = new IdentityHashMap<BundleWiring, BundleWiringDTO.NodeDTO>();

    private DTOBuilder() {
    }

    public static BundleDTO newBundleDTO(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        BundleDTO dto = new BundleDTO();
        dto.id = bundle.getBundleId();
        dto.lastModified = bundle.getLastModified();
        dto.state = bundle.getState();
        dto.symbolicName = bundle.getSymbolicName();
        dto.version = bundle.getVersion().toString();
        return dto;
    }

    public static BundleStartLevelDTO newBundleStartLevelDTO(Bundle b, BundleStartLevel bsl) {
        if (bsl == null) {
            return null;
        }
        BundleStartLevelDTO dto = new BundleStartLevelDTO();
        dto.bundle = b.getBundleId();
        dto.activationPolicyUsed = bsl.isActivationPolicyUsed();
        dto.persistentlyStarted = bsl.isPersistentlyStarted();
        dto.startLevel = bsl.getStartLevel();
        return dto;
    }

    public static BundleRevisionDTO newBundleRevisionDTO(BundleRevision revision) {
        BundleRevisionDTO dto = new DTOBuilder().getBundleRevisionDTO(revision);
        return dto;
    }

    private int getResourceId(BundleRevision revision) {
        BundleRevisionDTO dto = this.getBundleRevisionDTO(revision);
        if (dto == null) {
            return 0;
        }
        return dto.id;
    }

    private BundleRevisionDTO getBundleRevisionDTO(BundleRevision revision) {
        if (revision == null) {
            return null;
        }
        BundleRevisionDTO dto = this.resources.get(revision);
        if (dto != null) {
            return dto;
        }
        dto = new BundleRevisionDTO();
        dto.id = DTOBuilder.identifier(revision);
        this.resources.put(revision, dto);
        dto.bundle = revision.getBundle().getBundleId();
        dto.symbolicName = revision.getSymbolicName();
        dto.type = revision.getTypes();
        dto.version = revision.getVersion().toString();
        dto.capabilities = this.getListCapabilityDTO(revision.getDeclaredCapabilities(null));
        dto.requirements = this.getListRequirementDTO(revision.getDeclaredRequirements(null));
        return dto;
    }

    private List<CapabilityDTO> getListCapabilityDTO(List<BundleCapability> caps) {
        if (caps == null) {
            return null;
        }
        List<CapabilityDTO> dtos = DTOBuilder.newList(caps.size());
        for (BundleCapability cap : caps) {
            dtos.add(this.getCapabilityDTO(cap));
        }
        return dtos;
    }

    private CapabilityDTO getCapabilityDTO(BundleCapability cap) {
        if (cap == null) {
            return null;
        }
        CapabilityDTO dto = new CapabilityDTO();
        dto.id = DTOBuilder.identifier(cap);
        dto.namespace = cap.getNamespace();
        dto.resource = this.getResourceId(cap.getRevision());
        dto.attributes = DTOBuilder.newAttributesMapDTO(cap.getAttributes());
        dto.directives = DTOBuilder.newDirectivesMapDTO(cap.getDirectives());
        return dto;
    }

    private List<CapabilityRefDTO> getListCapabilityRefDTO(List<ModuleCapability> caps) {
        if (caps == null) {
            return null;
        }
        List<CapabilityRefDTO> dtos = DTOBuilder.newList(caps.size());
        for (BundleCapability bundleCapability : caps) {
            dtos.add(this.getCapabilityRefDTO(bundleCapability));
        }
        return dtos;
    }

    private CapabilityRefDTO getCapabilityRefDTO(BundleCapability cap) {
        if (cap == null) {
            return null;
        }
        CapabilityRefDTO dto = new CapabilityRefDTO();
        dto.capability = DTOBuilder.identifier(cap);
        dto.resource = this.getResourceId(cap.getRevision());
        return dto;
    }

    private List<RequirementDTO> getListRequirementDTO(List<BundleRequirement> reqs) {
        if (reqs == null) {
            return null;
        }
        List<RequirementDTO> dtos = DTOBuilder.newList(reqs.size());
        for (BundleRequirement req : reqs) {
            dtos.add(this.getRequirementDTO(req));
        }
        return dtos;
    }

    private RequirementDTO getRequirementDTO(BundleRequirement req) {
        if (req == null) {
            return null;
        }
        RequirementDTO dto = new RequirementDTO();
        dto.id = DTOBuilder.identifier(req);
        dto.namespace = req.getNamespace();
        dto.resource = this.getResourceId(req.getRevision());
        dto.attributes = DTOBuilder.newAttributesMapDTO(req.getAttributes());
        dto.directives = DTOBuilder.newDirectivesMapDTO(req.getDirectives());
        return dto;
    }

    private List<RequirementRefDTO> getListRequirementRefDTO(List<ModuleRequirement> reqs) {
        if (reqs == null) {
            return null;
        }
        List<RequirementRefDTO> dtos = DTOBuilder.newList(reqs.size());
        for (ModuleRequirement req : reqs) {
            dtos.add(this.getRequirementRefDTO(req));
        }
        return dtos;
    }

    private RequirementRefDTO getRequirementRefDTO(ModuleRequirement req) {
        if (req == null) {
            return null;
        }
        RequirementRefDTO dto = new RequirementRefDTO();
        dto.requirement = DTOBuilder.identifier(req);
        dto.resource = this.getResourceId(req.getRevision());
        return dto;
    }

    public static BundleRevisionDTO[] newArrayBundleRevisionDTO(BundleRevisions revisions) {
        if (revisions == null) {
            return null;
        }
        List<BundleRevision> revs = revisions.getRevisions();
        int size = revs.size();
        BundleRevisionDTO[] dtos = new BundleRevisionDTO[size];
        int i2 = 0;
        while (i2 < size) {
            dtos[i2] = new DTOBuilder().getBundleRevisionDTO(revs.get(i2));
            ++i2;
        }
        return dtos;
    }

    public static BundleWiringDTO newBundleWiringDTO(BundleRevision revision) {
        if (revision == null) {
            return null;
        }
        BundleWiringDTO dto = new DTOBuilder().getBundleWiringDTO((ModuleWiring)revision.getWiring());
        return dto;
    }

    public static FrameworkWiringDTO newFrameworkWiringDTO(Collection<ModuleWiring> allWirings) {
        DTOBuilder builder = new DTOBuilder();
        for (ModuleWiring wiring : allWirings) {
            builder.getBundleWiringNodeDTO(wiring);
        }
        FrameworkWiringDTO dto = new FrameworkWiringDTO();
        dto.wirings = new HashSet<BundleWiringDTO.NodeDTO>(builder.wiringnodes.values());
        dto.resources = new HashSet<BundleRevisionDTO>(builder.resources.values());
        return dto;
    }

    private BundleWiringDTO getBundleWiringDTO(ModuleWiring wiring) {
        if (wiring == null) {
            return null;
        }
        BundleWiringDTO dto = new BundleWiringDTO();
        dto.bundle = wiring.getBundle().getBundleId();
        dto.root = this.getWiringId(wiring);
        dto.nodes = new HashSet<BundleWiringDTO.NodeDTO>(this.wiringnodes.values());
        dto.resources = new HashSet<BundleRevisionDTO>(this.resources.values());
        return dto;
    }

    private int getWiringId(ModuleWiring wiring) {
        BundleWiringDTO.NodeDTO dto = this.getBundleWiringNodeDTO(wiring);
        if (dto == null) {
            return 0;
        }
        return dto.id;
    }

    private BundleWiringDTO.NodeDTO getBundleWiringNodeDTO(ModuleWiring wiring) {
        if (wiring == null) {
            return null;
        }
        BundleWiringDTO.NodeDTO dto = this.wiringnodes.get(wiring);
        if (dto != null) {
            return dto;
        }
        dto = new BundleWiringDTO.NodeDTO();
        dto.id = DTOBuilder.identifier(wiring);
        this.wiringnodes.put(wiring, dto);
        dto.current = wiring.isCurrent();
        dto.inUse = wiring.isInUse();
        dto.resource = this.getResourceId(wiring.getRevision());
        dto.capabilities = this.getListCapabilityRefDTO(wiring.getModuleCapabilities(null));
        dto.requirements = this.getListRequirementRefDTO(wiring.getModuleRequirements(null));
        dto.providedWires = this.getListBundleWireDTO(wiring.getProvidedModuleWires(null));
        dto.requiredWires = this.getListBundleWireDTO(wiring.getRequiredModuleWires(null));
        return dto;
    }

    private List<WireDTO> getListBundleWireDTO(List<ModuleWire> wires) {
        if (wires == null) {
            return null;
        }
        List<WireDTO> dtos = DTOBuilder.newList(wires.size());
        for (ModuleWire wire : wires) {
            dtos.add(this.getBundleWireDTO(wire));
        }
        return dtos;
    }

    private BundleWireDTO getBundleWireDTO(ModuleWire wire) {
        if (wire == null) {
            return null;
        }
        BundleWireDTO dto = new BundleWireDTO();
        dto.capability = this.getCapabilityRefDTO(wire.getCapability());
        dto.requirement = this.getRequirementRefDTO(wire.getRequirement());
        dto.provider = this.getResourceId(wire.getProvider());
        dto.requirer = this.getResourceId(wire.getRequirer());
        dto.providerWiring = this.getWiringId(wire.getProviderWiring());
        dto.requirerWiring = this.getWiringId(wire.getRequirerWiring());
        return dto;
    }

    public static BundleWiringDTO[] newArrayBundleWiringDTO(BundleRevisions revisions) {
        if (revisions == null) {
            return null;
        }
        List<BundleRevision> revs = revisions.getRevisions();
        int size = revs.size();
        ArrayList<BundleWiringDTO> dtos = new ArrayList<BundleWiringDTO>(size);
        int i2 = 0;
        while (i2 < size) {
            ModuleWiring wiring = (ModuleWiring)revs.get(i2).getWiring();
            if (wiring != null) {
                dtos.add(new DTOBuilder().getBundleWiringDTO(wiring));
            }
            ++i2;
        }
        return dtos.toArray(new BundleWiringDTO[dtos.size()]);
    }

    public static FrameworkDTO newFrameworkDTO(BundleContext systemBundleContext, Map<String, String> configuration) {
        FrameworkDTO dto = new FrameworkDTO();
        dto.properties = DTOBuilder.asProperties(configuration);
        if (systemBundleContext == null) {
            dto.bundles = DTOBuilder.newList(0);
            dto.services = DTOBuilder.newList(0);
            return dto;
        }
        Bundle[] bundles = systemBundleContext.getBundles();
        int size = bundles == null ? 0 : bundles.length;
        List<BundleDTO> bundleDTOs = DTOBuilder.newList(size);
        int i2 = 0;
        while (i2 < size) {
            bundleDTOs.add(DTOBuilder.newBundleDTO(bundles[i2]));
            ++i2;
        }
        dto.bundles = bundleDTOs;
        try {
            ServiceReference<?>[] references = systemBundleContext.getAllServiceReferences(null, null);
            size = references == null ? 0 : references.length;
            List<ServiceReferenceDTO> refDTOs = DTOBuilder.newList(size);
            int i3 = 0;
            while (i3 < size) {
                ServiceReferenceDTO serviceRefDTO = DTOBuilder.newServiceReferenceDTO(references[i3]);
                if (serviceRefDTO != null) {
                    refDTOs.add(serviceRefDTO);
                }
                ++i3;
            }
            dto.services = refDTOs;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            dto.services = DTOBuilder.newList(0);
        }
        return dto;
    }

    private static Map<String, Object> asProperties(Map<String, ?> m) {
        return m;
    }

    public static ServiceReferenceDTO newServiceReferenceDTO(ServiceReference<?> ref) {
        if (ref == null) {
            return null;
        }
        ServiceReferenceDTO dto = new ServiceReferenceDTO();
        String[] keys = ref.getPropertyKeys();
        Map<String, Object> properties = DTOBuilder.newMap(keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            Object v = ref.getProperty(k);
            if ("service.id".equals(k)) {
                dto.id = (Long)v;
            }
            if ("service.bundleid".equals(k)) {
                dto.bundle = (Long)v;
            }
            properties.put(k, DTOBuilder.mapValue(v));
            ++n2;
        }
        dto.properties = properties;
        Bundle[] using = ref.getUsingBundles();
        int length = using == null ? 0 : using.length;
        long[] usingBundles = new long[length];
        int i2 = 0;
        while (i2 < length) {
            usingBundles[i2] = using[i2].getBundleId();
            ++i2;
        }
        dto.usingBundles = usingBundles;
        return dto;
    }

    public static FrameworkStartLevelDTO newFrameworkStartLevelDTO(FrameworkStartLevel fsl) {
        if (fsl == null) {
            return null;
        }
        FrameworkStartLevelDTO dto = new FrameworkStartLevelDTO();
        dto.initialBundleStartLevel = fsl.getInitialBundleStartLevel();
        dto.startLevel = fsl.getStartLevel();
        return dto;
    }

    public static ServiceReferenceDTO[] newArrayServiceReferenceDTO(ServiceReference<?>[] references) {
        if (references == null) {
            return null;
        }
        int length = references.length;
        ArrayList<ServiceReferenceDTO> refDTOs = new ArrayList<ServiceReferenceDTO>(length);
        int i2 = 0;
        while (i2 < length) {
            ServiceReferenceDTO dto = DTOBuilder.newServiceReferenceDTO(references[i2]);
            if (dto != null) {
                refDTOs.add(dto);
            }
            ++i2;
        }
        return refDTOs.toArray(new ServiceReferenceDTO[refDTOs.size()]);
    }

    private static Object mapValue(Object v) {
        if (v == null || v instanceof Number || v instanceof Boolean || v instanceof Character || v instanceof String || v instanceof DTO) {
            return v;
        }
        if (v instanceof Map) {
            Map m = (Map)v;
            Map<Object, Object> map2 = DTOBuilder.newMap(m.size());
            for (Map.Entry e : m.entrySet()) {
                map2.put(DTOBuilder.mapValue(e.getKey()), DTOBuilder.mapValue(e.getValue()));
            }
            return map2;
        }
        if (v instanceof List) {
            List c = (List)v;
            List<Object> list = DTOBuilder.newList(c.size());
            for (Object o : c) {
                list.add(DTOBuilder.mapValue(o));
            }
            return list;
        }
        if (v instanceof Set) {
            Set c = (Set)v;
            Set<Object> set = DTOBuilder.newSet(c.size());
            for (Object o : c) {
                set.add(DTOBuilder.mapValue(o));
            }
            return set;
        }
        if (v.getClass().isArray()) {
            int length = Array.getLength(v);
            Class<?> componentType = DTOBuilder.mapComponentType(v.getClass().getComponentType());
            Object array = Array.newInstance(componentType, length);
            int i2 = 0;
            while (i2 < length) {
                Array.set(array, i2, DTOBuilder.mapValue(Array.get(v, i2)));
                ++i2;
            }
            return array;
        }
        return String.valueOf(v);
    }

    private static Class<?> mapComponentType(Class<?> componentType) {
        if (componentType.isPrimitive() || componentType.isArray() || Object.class.equals(componentType) || Number.class.isAssignableFrom(componentType) || Boolean.class.isAssignableFrom(componentType) || Character.class.isAssignableFrom(componentType) || String.class.isAssignableFrom(componentType) || DTO.class.isAssignableFrom(componentType)) {
            return componentType;
        }
        if (Map.class.isAssignableFrom(componentType)) {
            return Map.class;
        }
        if (List.class.isAssignableFrom(componentType)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(componentType)) {
            return Set.class;
        }
        return String.class;
    }

    private static <E> List<E> newList(int size) {
        return new ArrayList(size);
    }

    private static <E> Set<E> newSet(int size) {
        return new HashSet(size);
    }

    private static <K, V> Map<K, V> newMap(int size) {
        return new HashMap(size);
    }

    private static Map<String, String> newDirectivesMapDTO(Map<String, String> map2) {
        HashMap<String, String> dto = new HashMap<String, String>(map2);
        return dto;
    }

    private static Map<String, Object> newAttributesMapDTO(Map<String, Object> map2) {
        HashMap<String, Object> dto = new HashMap<String, Object>(map2);
        for (Map.Entry entry : dto.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Version) {
                entry.setValue(String.valueOf(value));
                continue;
            }
            if (!(value instanceof List)) continue;
            ArrayList newList = new ArrayList((List)value);
            ListIterator<String> iter = newList.listIterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof Version)) continue;
                iter.set(String.valueOf(element));
            }
            entry.setValue(newList);
        }
        return dto;
    }

    private static int identifier(Object o) {
        return System.identityHashCode(o);
    }
}

