/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import paper.libs.org.eclipse.osgi.container.Module;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.BundleException;
import paper.libs.org.osgi.framework.ServiceReference;
import paper.libs.org.osgi.util.tracker.ServiceTracker;

public class SecureAction {
    private AccessControlContext controlContext = AccessController.getContext();

    SecureAction() {
    }

    public static PrivilegedAction<SecureAction> createSecureAction() {
        return new PrivilegedAction<SecureAction>(){

            @Override
            public SecureAction run() {
                return new SecureAction();
            }
        };
    }

    public String getProperty(final String property) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(property);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        }, this.controlContext);
    }

    public Properties getProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        }, this.controlContext);
    }

    public FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileInputStream(file);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                @Override
                public FileInputStream run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public FileOutputStream getFileOutputStream(final File file, final boolean append) throws FileNotFoundException {
        if (System.getSecurityManager() == null) {
            return new FileOutputStream(file.getAbsolutePath(), append);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(file.getAbsolutePath(), append);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof FileNotFoundException) {
                throw (FileNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public long length(final File file) {
        if (System.getSecurityManager() == null) {
            return file.length();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.length();
            }
        }, this.controlContext);
    }

    public String getCanonicalPath(final File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalPath();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws IOException {
                    return file.getCanonicalPath();
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public File getAbsoluteFile(final File file) {
        if (System.getSecurityManager() == null) {
            return file.getAbsoluteFile();
        }
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                return file.getAbsoluteFile();
            }
        }, this.controlContext);
    }

    public File getCanonicalFile(final File file) throws IOException {
        if (System.getSecurityManager() == null) {
            return file.getCanonicalFile();
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return file.getCanonicalFile();
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public boolean exists(final File file) {
        if (System.getSecurityManager() == null) {
            return file.exists();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public boolean mkdirs(final File file) {
        if (System.getSecurityManager() == null) {
            return file.mkdirs();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.mkdirs() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public boolean isDirectory(final File file) {
        if (System.getSecurityManager() == null) {
            return file.isDirectory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.isDirectory() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, this.controlContext);
    }

    public long lastModified(final File file) {
        if (System.getSecurityManager() == null) {
            return file.lastModified();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return file.lastModified();
            }
        }, this.controlContext);
    }

    public String[] list(final File file) {
        if (System.getSecurityManager() == null) {
            return file.list();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return file.list();
            }
        }, this.controlContext);
    }

    public ZipFile getZipFile(final File file, final boolean verify) throws IOException {
        try {
            if (System.getSecurityManager() == null) {
                return new ZipFile(file);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ZipFile>(){

                    @Override
                    public ZipFile run() throws IOException {
                        return verify ? new JarFile(file) : new ZipFile(file);
                    }
                }, this.controlContext);
            }
            catch (PrivilegedActionException e) {
                if (e.getException() instanceof IOException) {
                    throw (IOException)e.getException();
                }
                throw (RuntimeException)e.getException();
            }
        }
        catch (ZipException e) {
            ZipException zipNameException = new ZipException("Exception in opening zip file: " + file.getPath());
            zipNameException.initCause(e);
            throw zipNameException;
        }
        catch (IOException e) {
            throw new IOException("Exception in opening zip file: " + file.getPath(), e);
        }
    }

    public URL getURL(final String protocol, final String host, final int port, final String file, final URLStreamHandler handler) throws MalformedURLException {
        if (System.getSecurityManager() == null) {
            return new URL(protocol, host, port, file, handler);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL(protocol, host, port, file, handler);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof MalformedURLException) {
                throw (MalformedURLException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public Thread createThread(final Runnable target, final String name2, final ClassLoader contextLoader) {
        if (System.getSecurityManager() == null) {
            return this.createThread0(target, name2, contextLoader);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return SecureAction.this.createThread0(target, name2, contextLoader);
            }
        }, this.controlContext);
    }

    Thread createThread0(Runnable target, String name2, ClassLoader contextLoader) {
        Thread result = new Thread(target, name2);
        if (contextLoader != null) {
            result.setContextClassLoader(contextLoader);
        }
        return result;
    }

    public <S> S getService(final ServiceReference<S> reference, final BundleContext context) {
        if (System.getSecurityManager() == null) {
            return context.getService(reference);
        }
        return (S)AccessController.doPrivileged(new PrivilegedAction<S>(){

            @Override
            public S run() {
                return context.getService(reference);
            }
        }, this.controlContext);
    }

    public Class<?> forName(final String name2) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return Class.forName(name2);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    return Class.forName(name2);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public Class<?> loadSystemClass(final String name2) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            return systemClassLoader != null ? systemClassLoader.loadClass(name2) : BootClassLoaderHolder.bootClassLoader.loadClass(name2);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                    return systemClassLoader != null ? systemClassLoader.loadClass(name2) : BootClassLoaderHolder.bootClassLoader.loadClass(name2);
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public void open(final ServiceTracker<?, ?> tracker) {
        if (System.getSecurityManager() == null) {
            tracker.open();
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                tracker.open();
                return null;
            }
        }, this.controlContext);
    }

    public void start(final Module module, final Module.StartOptions ... options) throws BundleException {
        if (System.getSecurityManager() == null) {
            module.start(options);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws BundleException {
                    module.start(options);
                    return null;
                }
            }, this.controlContext);
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof BundleException) {
                throw (BundleException)e.getException();
            }
            throw (RuntimeException)e.getException();
        }
    }

    public BundleContext getContext(final Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getBundleContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){

            @Override
            public BundleContext run() {
                return bundle.getBundleContext();
            }
        }, this.controlContext);
    }

    public String getLocation(final Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getLocation();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return bundle.getLocation();
            }
        }, this.controlContext);
    }

    private static class BootClassLoaderHolder {
        static final ClassLoader bootClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ClassLoader(Object.class.getClassLoader()){};
            }
        });

        private BootClassLoaderHolder() {
        }
    }
}

