/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jface.text.projection;

import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.jface.text.BadPositionCategoryException;
import paper.libs.org.eclipse.jface.text.DefaultPositionUpdater;
import paper.libs.org.eclipse.jface.text.DocumentEvent;
import paper.libs.org.eclipse.jface.text.Position;
import paper.libs.org.eclipse.jface.text.projection.ProjectionDocumentEvent;
import paper.libs.org.eclipse.jface.text.projection.Segment;

class SegmentUpdater
extends DefaultPositionUpdater {
    private Segment fNextSegment = null;
    private boolean fIsProjectionChange = false;

    protected SegmentUpdater(String segmentCategory) {
        super(segmentCategory);
    }

    @Override
    public void update(DocumentEvent event) {
        Assert.isTrue(event instanceof ProjectionDocumentEvent);
        this.fIsProjectionChange = ((ProjectionDocumentEvent)event).getChangeType() == ProjectionDocumentEvent.PROJECTION_CHANGE;
        try {
            Position[] category = event.getDocument().getPositions(this.getCategory());
            this.fOffset = event.getOffset();
            this.fLength = event.getLength();
            this.fReplaceLength = event.getText() == null ? 0 : event.getText().length();
            this.fDocument = event.getDocument();
            int i2 = 0;
            while (i2 < category.length) {
                this.fPosition = category[i2];
                Assert.isTrue(this.fPosition instanceof Segment);
                this.fNextSegment = i2 < category.length - 1 ? (Segment)category[i2 + 1] : null;
                this.fOriginalPosition.offset = this.fPosition.offset;
                this.fOriginalPosition.length = this.fPosition.length;
                if (this.notDeleted()) {
                    this.adaptToReplace();
                }
                ++i2;
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    @Override
    protected void adaptToInsert() {
        Segment segment = (Segment)this.fPosition;
        int myStart = segment.offset;
        int myEnd = segment.offset + segment.length - (segment.isMarkedForStretch || this.fNextSegment == null || this.isAffectingReplace() ? 0 : 1);
        myEnd = Math.max(myStart, myEnd);
        int yoursStart = this.fOffset;
        try {
            if (myEnd < yoursStart) {
                return;
            }
            if (segment.isMarkedForStretch) {
                Assert.isTrue(this.fIsProjectionChange);
                segment.isMarkedForShift = false;
                if (this.fNextSegment != null) {
                    this.fNextSegment.isMarkedForShift = true;
                    this.fNextSegment.isMarkedForStretch = false;
                }
            }
            if (this.fLength <= 0) {
                if (myStart < yoursStart + (segment.isMarkedForShift ? 0 : 1)) {
                    this.fPosition.length += this.fReplaceLength;
                } else {
                    this.fPosition.offset += this.fReplaceLength;
                }
            } else if (myStart <= yoursStart && this.fOriginalPosition.offset <= yoursStart) {
                this.fPosition.length += this.fReplaceLength;
            } else {
                this.fPosition.offset += this.fReplaceLength;
            }
        }
        finally {
            segment.clearMark();
        }
    }
}

