/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.util;

import paper.libs.org.eclipse.jdt.core.util.ClassFormatException;
import paper.libs.org.eclipse.jdt.core.util.IConstantPool;
import paper.libs.org.eclipse.jdt.core.util.IStackMapAttribute;
import paper.libs.org.eclipse.jdt.core.util.IStackMapFrame;
import paper.libs.org.eclipse.jdt.internal.core.util.ClassFileAttribute;
import paper.libs.org.eclipse.jdt.internal.core.util.DefaultStackMapFrame;

public class StackMapAttribute
extends ClassFileAttribute
implements IStackMapAttribute {
    private static final IStackMapFrame[] NO_FRAMES = new IStackMapFrame[0];
    private static final byte[] NO_ENTRIES = new byte[0];
    private int numberOfEntries;
    private IStackMapFrame[] frames;
    private byte[] bytes;

    public StackMapAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.numberOfEntries = length = this.u2At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 8;
            this.frames = new IStackMapFrame[length];
            int i2 = 0;
            while (i2 < length) {
                DefaultStackMapFrame frame = new DefaultStackMapFrame(classFileBytes, constantPool, offset + readOffset);
                this.frames[i2] = frame;
                readOffset += frame.sizeInBytes();
                ++i2;
            }
        } else {
            this.frames = NO_FRAMES;
        }
        int byteLength = (int)this.u4At(classFileBytes, 2, offset);
        if (length != 0) {
            this.bytes = new byte[byteLength];
            System.arraycopy(classFileBytes, offset + 6, this.bytes, 0, byteLength);
        } else {
            this.bytes = NO_ENTRIES;
        }
    }

    @Override
    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    @Override
    public IStackMapFrame[] getStackMapFrame() {
        return this.frames;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

