/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.matching;

import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.OperationCanceledException;
import paper.libs.org.eclipse.jdt.core.IMember;
import paper.libs.org.eclipse.jdt.core.IMethod;
import paper.libs.org.eclipse.jdt.core.IModuleDescription;
import paper.libs.org.eclipse.jdt.core.IPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.ITypeParameter;
import paper.libs.org.eclipse.jdt.core.Signature;
import paper.libs.org.eclipse.jdt.core.search.IJavaSearchScope;
import paper.libs.org.eclipse.jdt.core.search.SearchParticipant;
import paper.libs.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import paper.libs.org.eclipse.jdt.internal.core.index.Index;
import paper.libs.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import paper.libs.org.eclipse.jdt.internal.core.search.JavaSearchScope;
import paper.libs.org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class TypeParameterPattern
extends JavaSearchPattern {
    protected boolean findDeclarations;
    protected boolean findReferences;
    protected char[] name;
    protected ITypeParameter typeParameter;
    protected char[] declaringMemberName;
    protected char[] methodDeclaringClassName;
    protected char[][] methodArgumentTypes;

    public TypeParameterPattern(boolean findDeclarations, boolean findReferences, ITypeParameter typeParameter, int matchRule) {
        super(1024, matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.typeParameter = typeParameter;
        this.name = typeParameter.getElementName().toCharArray();
        IMember member = typeParameter.getDeclaringMember();
        this.declaringMemberName = member.getElementName().toCharArray();
        if (member instanceof IMethod) {
            IMethod method = (IMethod)member;
            this.methodDeclaringClassName = method.getParent().getElementName().toCharArray();
            String[] parameters = method.getParameterTypes();
            int length = parameters.length;
            this.methodArgumentTypes = new char[length][];
            int i2 = 0;
            while (i2 < length) {
                this.methodArgumentTypes[i2] = Signature.toCharArray(parameters[i2].toCharArray());
                ++i2;
            }
        }
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        JavaSearchScope javaSearchScope;
        AccessRuleSet access;
        String documentPath;
        String relativePath;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.typeParameter.getAncestor(3);
        if (root.isArchive()) {
            IType type = (IType)this.typeParameter.getAncestor(7);
            relativePath = String.valueOf(type.getFullyQualifiedName('$').replace('.', '/')) + ".class";
            IModuleDescription md = root.getModuleDescription();
            if (md != null) {
                String module = md.getElementName();
                documentPath = root.getPath() + "|" + module + "|" + relativePath;
            } else {
                documentPath = root.getPath() + "|" + relativePath;
            }
        } else {
            IPath path = this.typeParameter.getPath();
            documentPath = path.toString();
            relativePath = Util.relativePath(path, 1);
        }
        if (scope instanceof JavaSearchScope ? (access = (javaSearchScope = (JavaSearchScope)scope).getAccessRuleSet(relativePath, index.containerPath)) != JavaSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath, this, participant, access) : scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, this, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentName, IProgressMonitor progressMonitor) {
        this.findIndexMatches(index, requestor, participant, scope, progressMonitor);
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "TypeParamCombinedPattern: " : "TypeParamDeclarationPattern: ");
        } else {
            output.append("TypeParamReferencePattern: ");
        }
        output.append(this.typeParameter.toString());
        return super.print(output);
    }
}

