/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.indexing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.SubMonitor;
import paper.libs.org.eclipse.core.runtime.jobs.Job;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.core.search.processing.JobManager;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class IndexNamesRegistry {
    private final File savedIndexNamesFile;
    private final Job writeJob;
    private final IPath javaPluginWorkingLocation;
    private final Object queueMutex = new Object();
    private char[][] pendingWrite;

    public IndexNamesRegistry(File savedIndexNamesFile, IPath javaPluginWorkingLocation) {
        this.savedIndexNamesFile = savedIndexNamesFile;
        this.writeJob = Job.create("Updating index names", this::save);
        this.writeJob.setSystem(true);
        this.javaPluginWorkingLocation = javaPluginWorkingLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[][] newContents) {
        Object object = this.queueMutex;
        synchronized (object) {
            this.pendingWrite = newContents;
        }
        this.writeJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[][] read(IProgressMonitor monitor) {
        block7: {
            char[][] newContents;
            Object object = this.queueMutex;
            synchronized (object) {
                newContents = this.pendingWrite;
            }
            if (newContents != null) {
                return newContents;
            }
            try {
                String savedSignature;
                char[][] names;
                char[] savedIndexNames = paper.libs.org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(this.savedIndexNamesFile, null);
                if (savedIndexNames.length > 0 && (names = CharOperation.splitOn('\n', savedIndexNames)).length > 1 && (savedSignature = "INDEX VERSION 1.131+" + this.javaPluginWorkingLocation.toOSString()).equals(new String(names[0]))) {
                    return names;
                }
            }
            catch (IOException iOException) {
                if (!JobManager.VERBOSE) break block7;
                Util.verbose("Failed to read saved index file names");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(IProgressMonitor monitor) {
        char[][] newContents;
        Object object;
        block20: {
            SubMonitor subMonitor = SubMonitor.convert(monitor);
            object = this.queueMutex;
            synchronized (object) {
                newContents = this.pendingWrite;
            }
            if (newContents == null) {
                return;
            }
            subMonitor.setWorkRemaining(newContents.length);
            try {
                object = null;
                Object var5_6 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));){
                    writer.write("INDEX VERSION 1.131");
                    writer.write(43);
                    writer.write(this.javaPluginWorkingLocation.toOSString());
                    writer.write(10);
                    char[][] cArray = newContents;
                    int n = newContents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char[] next = cArray[n2];
                        subMonitor.split(1);
                        writer.write(next);
                        writer.write(10);
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (IOException iOException) {
                if (!JobManager.VERBOSE) break block20;
                Util.verbose("Failed to write saved index file names", System.err);
            }
        }
        object = this.queueMutex;
        synchronized (object) {
            if (this.pendingWrite == newContents) {
                this.pendingWrite = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = this.queueMutex;
        synchronized (object) {
            this.pendingWrite = null;
        }
        this.writeJob.cancel();
        try {
            this.writeJob.join();
        }
        catch (InterruptedException interruptedException) {}
        object = this.queueMutex;
        synchronized (object) {
            this.pendingWrite = null;
        }
        this.savedIndexNamesFile.delete();
    }
}

