/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search;

import paper.libs.org.eclipse.jdt.core.IMethod;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.Signature;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.core.search.IJavaSearchScope;
import paper.libs.org.eclipse.jdt.core.search.MethodNameMatchRequestor;
import paper.libs.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import paper.libs.org.eclipse.jdt.internal.core.search.HierarchyScope;
import paper.libs.org.eclipse.jdt.internal.core.search.IRestrictedAccessMethodRequestor;
import paper.libs.org.eclipse.jdt.internal.core.search.JavaSearchMethodNameMatch;
import paper.libs.org.eclipse.jdt.internal.core.search.NameMatchRequestorWrapper;

public class MethodNameMatchRequestorWrapper
extends NameMatchRequestorWrapper
implements IRestrictedAccessMethodRequestor {
    MethodNameMatchRequestor requestor;

    public MethodNameMatchRequestorWrapper(MethodNameMatchRequestor requestor, IJavaSearchScope scope) {
        super(scope);
        this.requestor = requestor;
    }

    @Override
    public void acceptMethod(char[] methodName, int parameterCount, char[] declaringQualifier, char[] simpleTypeName, int typeModifiers, char[] packageName, char[] signature, char[][] parameterTypes, char[][] parameterNames, char[] returnType, int modifiers, String path, AccessRestriction access, int methodIndex) {
        char[][] enclosingTypeNames = declaringQualifier != null && declaringQualifier.length > 0 ? CharOperation.splitOn('.', declaringQualifier) : CharOperation.NO_CHAR_CHAR;
        IType type = this.getType(typeModifiers, packageName, simpleTypeName, enclosingTypeNames, path, access);
        if (type == null) {
            return;
        }
        if (this.scope instanceof HierarchyScope && !((HierarchyScope)this.scope).enclosesFineGrained(type)) {
            return;
        }
        parameterTypes = parameterTypes == null ? CharOperation.NO_CHAR_CHAR : parameterTypes;
        String[] paramTypeSigs = CharOperation.NO_STRINGS;
        if (signature != null) {
            char[][] parTypes = Signature.getParameterTypes(signature);
            if (parTypes.length > 0) {
                int i2 = 0;
                int l = parTypes.length;
                while (i2 < l) {
                    CharOperation.replace(parTypes[i2], '/', '.');
                    ++i2;
                }
            }
            paramTypeSigs = CharOperation.toStrings(parTypes);
        } else if (parameterTypes.length > 0) {
            int l = parameterTypes.length;
            paramTypeSigs = new String[l];
            int i3 = 0;
            while (i3 < l) {
                paramTypeSigs[i3] = Signature.createTypeSignature(parameterTypes[i3], false);
                ++i3;
            }
        }
        IMethod method = type.getMethod(new String(methodName), paramTypeSigs);
        this.requestor.acceptMethodNameMatch(new JavaSearchMethodNameMatch(method, modifiers));
    }
}

