/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import paper.libs.org.eclipse.core.resources.IFolder;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaModel;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IMethod;
import paper.libs.org.eclipse.jdt.core.IPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.ITypeHierarchy;
import paper.libs.org.eclipse.jdt.core.ITypeRoot;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.core.search.IJavaSearchScope;
import paper.libs.org.eclipse.jdt.core.search.SearchPattern;
import paper.libs.org.eclipse.jdt.internal.compiler.util.ObjectVector;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import paper.libs.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.JavaModel;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.builder.ReferenceCollection;
import paper.libs.org.eclipse.jdt.internal.core.builder.State;
import paper.libs.org.eclipse.jdt.internal.core.index.IndexLocation;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.QualifierQuery;
import paper.libs.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import paper.libs.org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import paper.libs.org.eclipse.jdt.internal.core.search.matching.ModulePattern;
import paper.libs.org.eclipse.jdt.internal.core.search.processing.JobManager;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class IndexSelector {
    public static final int PROJECT_CAN_SEE_FOCUS = 0;
    public static final int PROJECT_SOURCE_CAN_NOT_SEE_FOCUS = 1;
    public static final int PROJECT_CAN_NOT_SEE_FOCUS = 2;
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IndexLocation[] indexLocations;

    public IndexSelector(IJavaSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int canSeeFocus(SearchPattern pattern, IPath projectOrJarPath) {
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            IJavaProject project = IndexSelector.getJavaProject(projectOrJarPath, model);
            IJavaElement[] focuses = IndexSelector.getFocusedElementsAndTypes(pattern, project, null);
            if (focuses.length == 0) {
                return 2;
            }
            if (project != null) {
                return IndexSelector.canSeeFocus(focuses, (JavaProject)project, null);
            }
            int result = 2;
            IJavaProject[] allProjects = model.getJavaProjects();
            int i2 = 0;
            int length = allProjects.length;
            while (true) {
                if (i2 >= length) {
                    return result;
                }
                JavaProject otherProject = (JavaProject)allProjects[i2];
                IClasspathEntry entry = otherProject.getClasspathEntryFor(projectOrJarPath);
                if (entry != null && entry.getEntryKind() == 1) {
                    int canSeeFocus = IndexSelector.canSeeFocus(focuses, otherProject, null);
                    if (canSeeFocus == 0) {
                        return 0;
                    }
                    if (canSeeFocus == 1) {
                        result = 1;
                    }
                }
                ++i2;
            }
        }
        catch (JavaModelException javaModelException) {
            return 2;
        }
    }

    private static int canSeeFocus(IJavaElement[] focuses, JavaProject javaProject, char[][][] focusQualifiedNames) {
        int result = 2;
        int length = focuses.length;
        int i2 = 0;
        while (i2 < length) {
            int canSeeFocus = IndexSelector.canSeeFocus(focuses[i2], javaProject, focusQualifiedNames);
            if (canSeeFocus == 0) {
                return 0;
            }
            if (canSeeFocus == 1) {
                result = 1;
            }
            ++i2;
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static int canSeeFocus(IJavaElement focus, JavaProject javaProject, char[][][] focusQualifiedNames) {
        try {
            if (focus == null) {
                return 2;
            }
            if (focus.equals(javaProject)) {
                return 0;
            }
            if (focus instanceof JarPackageFragmentRoot) {
                IPath focusPath = focus.getPath();
                IClasspathEntry[] entries = javaProject.getExpandedClasspath();
                int i2 = 0;
                int length = entries.length;
                while (i2 < length) {
                    IClasspathEntry entry = entries[i2];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals(focusPath)) {
                        return 0;
                    }
                    ++i2;
                }
                return 2;
            }
            IPath focusPath = ((JavaProject)focus).getProject().getFullPath();
            IClasspathEntry[] entries = javaProject.getExpandedClasspath();
            int i3 = 0;
            int length = entries.length;
            while (i3 < length) {
                IClasspathEntry entry = entries[i3];
                if (entry.getEntryKind() == 2 && entry.getPath().equals(focusPath)) {
                    State projectState;
                    if (focusQualifiedNames != null && (projectState = (State)JavaModelManager.getJavaModelManager().getLastBuiltState(javaProject.getProject(), null)) != null) {
                        Collection<ReferenceCollection> values = projectState.getReferences().values();
                        for (ReferenceCollection references : values) {
                            if (references == null || !references.includes(focusQualifiedNames, null, null)) continue;
                            return 0;
                        }
                        return 1;
                    }
                    return 0;
                }
                ++i3;
            }
            return 2;
        }
        catch (JavaModelException javaModelException) {
            return 2;
        }
    }

    private static IJavaElement[] getFocusedElementsAndTypes(SearchPattern pattern, IJavaElement focusElement, ObjectVector superTypes) throws JavaModelException {
        if (pattern instanceof MethodPattern) {
            IType type = (IType)pattern.focus.getAncestor(7);
            MethodPattern methodPattern = (MethodPattern)pattern;
            String selector = new String(methodPattern.selector);
            int parameterCount = methodPattern.parameterCount;
            ITypeHierarchy superHierarchy = type.newSupertypeHierarchy(null);
            IType[] allTypes = superHierarchy.getAllSupertypes(type);
            int length = allTypes.length;
            SimpleSet focusSet = new SimpleSet(length + 1);
            if (focusElement != null) {
                focusSet.add(focusElement);
            }
            int i2 = 0;
            while (i2 < length) {
                IMethod[] methods = allTypes[i2].getMethods();
                int mLength = methods.length;
                int m = 0;
                while (m < mLength) {
                    if (parameterCount == methods[m].getNumberOfParameters() && methods[m].getElementName().equals(selector)) {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)allTypes[i2].getAncestor(3);
                        IJavaElement element = root.isArchive() ? root : root.getParent();
                        focusSet.add(element);
                        if (superTypes == null) break;
                        superTypes.add(allTypes[i2]);
                        break;
                    }
                    ++m;
                }
                ++i2;
            }
            IJavaElement[] focuses = new IJavaElement[focusSet.elementSize];
            Object[] values = focusSet.values;
            int count = 0;
            int i3 = values.length;
            while (--i3 >= 0) {
                if (values[i3] == null) continue;
                focuses[count++] = (IJavaElement)values[i3];
            }
            return focuses;
        }
        if (focusElement == null) {
            return new IJavaElement[0];
        }
        return new IJavaElement[]{focusElement};
    }

    private void initializeIndexLocations() {
        IJavaElement focus;
        IPath[] projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        IndexManager manager = JavaModelManager.getIndexManager();
        LinkedHashSet<IndexLocation> locations = new LinkedHashSet<IndexLocation>();
        IJavaElement iJavaElement = focus = this.pattern instanceof ModulePattern ? null : MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            int i2 = 0;
            while (i2 < projectsAndJars.length) {
                IPath path = projectsAndJars[i2];
                Object target = JavaModel.getTarget(path, false);
                if (target instanceof IFolder) {
                    path = ((IFolder)target).getFullPath();
                }
                locations.add(manager.computeIndexLocation(path));
                ++i2;
            }
        } else {
            try {
                int length = projectsAndJars.length;
                JavaProject[] projectsCanSeeFocus = new JavaProject[length];
                SimpleSet visitedProjects = new SimpleSet(length);
                int projectIndex = 0;
                SimpleSet externalLibsToCheck = new SimpleSet(length);
                ObjectVector superTypes = new ObjectVector();
                IJavaElement[] focuses = IndexSelector.getFocusedElementsAndTypes(this.pattern, focus, superTypes);
                char[][][] focusQualifiedNames = null;
                boolean isAutoBuilding = ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
                if (isAutoBuilding && focus instanceof IJavaProject) {
                    focusQualifiedNames = this.getQualifiedNames(superTypes);
                }
                JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                int i3 = 0;
                while (i3 < length) {
                    IPath path = projectsAndJars[i3];
                    JavaProject project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        int canSeeFocus = IndexSelector.canSeeFocus(focuses, project, focusQualifiedNames);
                        if (canSeeFocus == 0) {
                            locations.add(manager.computeIndexLocation(path));
                        }
                        if (canSeeFocus != 2) {
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        externalLibsToCheck.add(path);
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < projectIndex && externalLibsToCheck.elementSize > 0) {
                    IClasspathEntry[] entries = projectsCanSeeFocus[i3].getResolvedClasspath();
                    int j = entries.length;
                    while (--j >= 0) {
                        IPath path;
                        IClasspathEntry entry = entries[j];
                        if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                        Object target = JavaModel.getTarget(path, false);
                        if (target instanceof IFolder) {
                            path = ((IFolder)target).getFullPath();
                        }
                        locations.add(manager.computeIndexLocation(path));
                    }
                    ++i3;
                }
                if (externalLibsToCheck.elementSize > 0) {
                    IJavaProject[] allProjects = model.getJavaProjects();
                    int i4 = 0;
                    int l = allProjects.length;
                    while (i4 < l && externalLibsToCheck.elementSize > 0) {
                        JavaProject project = (JavaProject)allProjects[i4];
                        if (!visitedProjects.includes(project)) {
                            IClasspathEntry[] entries = project.getResolvedClasspath();
                            int j = entries.length;
                            while (--j >= 0) {
                                IPath path;
                                IClasspathEntry entry = entries[j];
                                if (entry.getEntryKind() != 1 || externalLibsToCheck.remove(path = entry.getPath()) == null) continue;
                                Object target = JavaModel.getTarget(path, false);
                                if (target instanceof IFolder) {
                                    path = ((IFolder)target).getFullPath();
                                }
                                locations.add(manager.computeIndexLocation(path));
                            }
                        }
                        ++i4;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        locations.remove(null);
        this.indexLocations = locations.toArray(new IndexLocation[locations.size()]);
    }

    public IndexLocation[] getIndexLocations() {
        Optional<Set<String>> indexNamesResult;
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        IndexLocation[] filtered = this.indexLocations;
        if (this.pattern != null && this.pattern.indexQualifierQuery != null && this.pattern.indexQualifierQuery.length > 0 && (indexNamesResult = JavaModelManager.getIndexManager().findMatchingIndexNames(QualifierQuery.fromEncodedQuery(this.pattern.indexQualifierQuery))).isPresent()) {
            Set<String> indexNames = indexNamesResult.get();
            filtered = (IndexLocation[])Stream.of(this.indexLocations).filter(l -> indexNames.contains(l.fileName())).toArray(IndexLocation[]::new);
        }
        if (JobManager.VERBOSE) {
            Util.verbose(String.format("-> selected %s indexes out of total indexes %s after qualify filtering - %s", filtered.length, this.indexLocations.length, this.toString()));
        }
        return filtered;
    }

    private static IJavaProject getJavaProject(IPath path, IJavaModel model) {
        IJavaProject project;
        String lastSeg = path.lastSegment();
        if (lastSeg == null) {
            lastSeg = path.toOSString();
        }
        if ((project = model.getJavaProject(lastSeg)).exists()) {
            return project;
        }
        return null;
    }

    private char[][][] getQualifiedNames(ObjectVector types) {
        IType primaryType;
        int size = types.size;
        char[][][] focusQualifiedNames = null;
        IJavaElement javaElement = this.pattern.focus;
        int index = 0;
        while (javaElement != null && !(javaElement instanceof ITypeRoot)) {
            javaElement = javaElement.getParent();
        }
        if (javaElement != null && (primaryType = ((ITypeRoot)javaElement).findPrimaryType()) != null) {
            focusQualifiedNames = new char[size + 1][][];
            focusQualifiedNames[index++] = CharOperation.splitOn('.', primaryType.getFullyQualifiedName().toCharArray());
        }
        if (focusQualifiedNames == null) {
            focusQualifiedNames = new char[size][][];
        }
        int i2 = 0;
        while (i2 < size) {
            focusQualifiedNames[index++] = CharOperation.splitOn('.', ((IType)types.elementAt(i2)).getFullyQualifiedName().toCharArray());
            ++i2;
        }
        return focusQualifiedNames.length == 0 ? null : ReferenceCollection.internQualifiedNames(focusQualifiedNames, true);
    }
}

