/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.eval;

import java.util.HashMap;
import paper.libs.org.eclipse.core.resources.IMarker;
import paper.libs.org.eclipse.core.resources.ResourcesPlugin;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.jdt.core.compiler.CategorizedProblem;
import paper.libs.org.eclipse.jdt.core.eval.ICodeSnippetRequestor;
import paper.libs.org.eclipse.jdt.internal.compiler.ClassFile;
import paper.libs.org.eclipse.jdt.internal.eval.IRequestor;

public class RequestorWrapper
implements IRequestor {
    ICodeSnippetRequestor requestor;

    public RequestorWrapper(ICodeSnippetRequestor requestor) {
        this.requestor = requestor;
    }

    @Override
    public boolean acceptClassFiles(ClassFile[] classFiles, char[] codeSnippetClassName) {
        int length = classFiles.length;
        byte[][] classFileBytes = new byte[length][];
        String[][] compoundNames = new String[length][];
        int i2 = 0;
        while (i2 < length) {
            ClassFile classFile = classFiles[i2];
            classFileBytes[i2] = classFile.getBytes();
            char[][] classFileCompundName = classFile.getCompoundName();
            int length2 = classFileCompundName.length;
            String[] compoundName = new String[length2];
            int j = 0;
            while (j < length2) {
                compoundName[j] = new String(classFileCompundName[j]);
                ++j;
            }
            compoundNames[i2] = compoundName;
            ++i2;
        }
        return this.requestor.acceptClassFiles(classFileBytes, compoundNames, codeSnippetClassName == null ? null : new String(codeSnippetClassName));
    }

    @Override
    public void acceptProblem(CategorizedProblem problem, char[] fragmentSource, int fragmentKind) {
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("id", problem.getID());
            attributes.put("charStart", problem.getSourceStart());
            attributes.put("charEnd", problem.getSourceEnd() + 1);
            attributes.put("lineNumber", problem.getSourceLineNumber());
            attributes.put("message", problem.getMessage());
            attributes.put("severity", problem.isError() ? 2 : (problem.isWarning() ? 1 : 0));
            attributes.put("sourceId", "JDT");
            IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker("paper.libs.org.eclipse.jdt.core.transient_problem", attributes);
            this.requestor.acceptProblem(marker, new String(fragmentSource), fragmentKind);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

