/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.dom.util;

import paper.libs.org.eclipse.jdt.core.JavaCore;
import paper.libs.org.eclipse.jdt.core.dom.AST;

public class DOMASTUtil {
    private static final String[] AST_COMPLIANCE_MAP = new String[]{"-1", "-1", "1.2", "1.3", "1.7", "1.7", "1.7", "1.7", "1.8", "9", "10", "11", "12", "13", "14", "15", "16", "17"};

    private static boolean isNodeTypeSupportedinAST(AST ast, int nodeType) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast.apiLevel(), ast.isPreviewEnabledSet(), nodeType);
    }

    private static boolean isNodeTypeSupportedinAST(int apiLevel, boolean previewEnabled, int nodeType) {
        switch (nodeType) {
            case 100: 
            case 101: {
                return apiLevel >= 14;
            }
            case 102: {
                return apiLevel >= 15;
            }
            case 103: 
            case 104: {
                return apiLevel >= 16;
            }
            case 106: {
                return apiLevel == AST.getJLSLatest() && previewEnabled;
            }
        }
        return false;
    }

    public static boolean isFeatureSupportedinAST(AST ast, int featureName) {
        switch (featureName) {
            case 512: {
                return ast.apiLevel() >= 17;
            }
            case 4096: {
                return ast.apiLevel() >= 17;
            }
        }
        return false;
    }

    public static boolean isFeatureSupportedinAST(int apiLevel, boolean previewEnabled, int featureName) {
        switch (featureName) {
            case 512: {
                return apiLevel >= 17;
            }
            case 4096: {
                return apiLevel >= 17;
            }
        }
        return false;
    }

    public static boolean isFeatureSupportedinAST(int apiLevel, int featureName) {
        switch (featureName) {
            case 512: {
                return apiLevel >= 17;
            }
            case 4096: {
                return apiLevel >= 17;
            }
        }
        return false;
    }

    public static boolean isPreviewEnabled(int apiLevel, boolean previewEnabled) {
        return apiLevel == 17 && previewEnabled;
    }

    public static boolean isSwitchExpressionSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 100);
    }

    public static boolean isYieldStatementSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 101);
    }

    public static boolean isTextBlockSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 102);
    }

    public static boolean isRecordDeclarationSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 103);
    }

    public static boolean isRecordDeclarationSupported(int apiLevel) {
        return DOMASTUtil.isNodeTypeSupportedinAST(apiLevel, true, 103);
    }

    public static boolean isPatternInstanceofExpressionSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 104);
    }

    public static boolean isPatternSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 106);
    }

    public static boolean isPatternSupported(int apiLevel, boolean previewEnabled) {
        return DOMASTUtil.isNodeTypeSupportedinAST(apiLevel, previewEnabled, 106);
    }

    public static void checkASTLevel(int level) {
        if (level >= 8 && level <= AST.getJLSLatest()) {
            return;
        }
        switch (level) {
            case 2: 
            case 3: 
            case 4: {
                return;
            }
        }
        throw new IllegalArgumentException(Integer.toString(level));
    }

    public static String getCompliance(int astLevel) {
        if (astLevel < 2 && astLevel > AST.getJLSLatest()) {
            return JavaCore.latestSupportedJavaVersion();
        }
        return AST_COMPLIANCE_MAP[astLevel];
    }
}

