/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.dom.rewrite.imports;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.search.IJavaSearchScope;
import paper.libs.org.eclipse.jdt.core.search.SearchEngine;
import paper.libs.org.eclipse.jdt.core.search.TypeNameRequestor;
import paper.libs.org.eclipse.jdt.internal.core.dom.rewrite.imports.ConflictingSimpleNameFinder;

final class TypeConflictingSimpleNameFinder
implements ConflictingSimpleNameFinder {
    private final IJavaProject javaProject;
    private final SearchEngine searchEngine;

    private static char[][] stringsToCharArrays(Collection<String> strings) {
        char[][] arrayOfArrays = new char[strings.size()][];
        int i2 = 0;
        for (String string : strings) {
            arrayOfArrays[i2] = string.toCharArray();
            ++i2;
        }
        return arrayOfArrays;
    }

    TypeConflictingSimpleNameFinder(IJavaProject javaProject, SearchEngine searchEngine) {
        this.javaProject = javaProject;
        this.searchEngine = searchEngine;
    }

    @Override
    public Set<String> findConflictingSimpleNames(Set<String> simpleNames, Set<String> onDemandAndImplicitContainerNames, IProgressMonitor monitor) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{this.javaProject});
        ConflictAccumulatingTypeRequestor requestor = new ConflictAccumulatingTypeRequestor();
        this.searchEngine.searchAllTypeNames(TypeConflictingSimpleNameFinder.stringsToCharArrays(onDemandAndImplicitContainerNames), TypeConflictingSimpleNameFinder.stringsToCharArrays(simpleNames), scope, requestor, 3, monitor);
        return requestor.getNamesFoundInMultipleContainers();
    }

    private static class ConflictAccumulatingTypeRequestor
    extends TypeNameRequestor {
        private final Set<String> namesFoundInMultipleContainers = new HashSet<String>();
        private final Map<String, String> lastContainerFoundForType = new HashMap<String, String>();

        private static String buildContainerName(char[] packageName, char[][] enclosingTypeNames) {
            StringBuilder buf = new StringBuilder();
            buf.append(packageName);
            char[][] cArray = enclosingTypeNames;
            int n = enclosingTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                char[] enclosingTypeName = cArray[n2];
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(enclosingTypeName);
                ++n2;
            }
            return buf.toString();
        }

        ConflictAccumulatingTypeRequestor() {
        }

        @Override
        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            String simpleName = new String(simpleTypeName);
            String newContainerName = ConflictAccumulatingTypeRequestor.buildContainerName(packageName, enclosingTypeNames);
            String oldContainerName = this.lastContainerFoundForType.put(simpleName, newContainerName);
            if (oldContainerName != null && !oldContainerName.equals(newContainerName)) {
                this.namesFoundInMultipleContainers.add(simpleName);
            }
        }

        Set<String> getNamesFoundInMultipleContainers() {
            return Collections.unmodifiableSet(this.namesFoundInMultipleContainers);
        }
    }
}

