/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.builder;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class CompressedWriter {
    private final DataOutputStream out;
    private char[] lastName;
    private final HashMap<String, Integer> lastWords;

    public CompressedWriter(DataOutputStream out) {
        this.out = out;
        this.lastName = new char[0];
        this.lastWords = new HashMap();
    }

    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    public void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    public void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    public void writeChars(char[] name2) throws IOException {
        this.out.writeUTF(new String(name2));
    }

    public void writeIntWithHint(int v, int[] typical) throws IOException {
        int i2 = 0;
        while (i2 < typical.length) {
            if (typical[i2] == v) break;
            ++i2;
        }
        this.writeIntInRange(i2, typical.length + 1);
        if (i2 == typical.length) {
            this.writeInt(v);
        }
    }

    public void writeIntInRange(int v, int range) throws IOException {
        if (range < 0 || range > 65535) {
            this.out.writeInt(v);
        } else {
            if (v >= range) {
                throw new IllegalArgumentException(String.valueOf(v) + "/" + range);
            }
            if (v < 0) {
                throw new IllegalArgumentException(String.valueOf(v) + "/" + range);
            }
            if (range <= 255) {
                this.out.writeByte(v);
            } else {
                this.out.writeShort(v);
            }
        }
    }

    public void writeStringUsingDictionary(String v) throws IOException {
        int size = this.lastWords.size();
        Integer index = this.lastWords.putIfAbsent(v, size);
        if (index == null) {
            this.writeIntInRange(0, size + 1);
            this.out.writeUTF(v);
        } else {
            this.writeIntInRange(index + 1, size + 1);
        }
    }

    public void writeStringUsingLast(String name2) throws IOException {
        this.writeCharsUsingLast(name2.toCharArray());
    }

    public void writeCharsUsingLast(char[] name2) throws IOException {
        int commonLength = CompressedWriter.commonLength(name2, this.lastName, 255);
        this.out.writeByte(commonLength);
        this.writeStringUsingDictionary(new String(name2, commonLength, name2.length - commonLength));
        this.lastName = name2;
    }

    private static int commonLength(char[] a, char[] b, int max) {
        int i2 = 0;
        int end = Math.min(Math.min(max, a.length), b.length);
        while (i2 < end && a[i2] == b[i2]) {
            ++i2;
        }
        return i2;
    }
}

