/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.builder;

import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.CompilationResult;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.batch.BasicModule;
import paper.libs.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModule;
import paper.libs.org.eclipse.jdt.internal.compiler.parser.Parser;
import paper.libs.org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class ClasspathMultiDirectory
extends ClasspathDirectory {
    IContainer sourceFolder;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;
    boolean hasIndependentOutputFolder;
    public boolean ignoreOptionalProblems;

    ClasspathMultiDirectory(IContainer sourceFolder, IContainer binaryFolder, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean ignoreOptionalProblems, IPath externalAnnotationPath) {
        super(binaryFolder, true, null, externalAnnotationPath, false);
        this.sourceFolder = sourceFolder;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.hasIndependentOutputFolder = false;
        this.ignoreOptionalProblems = ignoreOptionalProblems;
        if (this.inclusionPatterns != null && this.inclusionPatterns.length == 0) {
            this.inclusionPatterns = null;
        }
        if (this.exclusionPatterns != null && this.exclusionPatterns.length == 0) {
            this.exclusionPatterns = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathMultiDirectory)) {
            return false;
        }
        ClasspathMultiDirectory md = (ClasspathMultiDirectory)o;
        return this.ignoreOptionalProblems == md.ignoreOptionalProblems && this.sourceFolder.equals(md.sourceFolder) && this.binaryFolder.equals(md.binaryFolder) && CharOperation.equals(this.inclusionPatterns, md.inclusionPatterns) && CharOperation.equals(this.exclusionPatterns, md.exclusionPatterns);
    }

    @Override
    protected boolean isExcluded(IResource resource) {
        if ((this.exclusionPatterns != null || this.inclusionPatterns != null) && this.sourceFolder.equals(this.binaryFolder)) {
            return Util.isExcluded(resource, this.inclusionPatterns, this.exclusionPatterns);
        }
        return false;
    }

    @Override
    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                String name2;
                IResource m;
                int l;
                int i2;
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                boolean foundClass = false;
                if (members.length > 0) {
                    i2 = 0;
                    l = members.length;
                    while (i2 < l) {
                        boolean isClass;
                        m = members[i2];
                        name2 = m.getName();
                        boolean bl = isClass = m.getType() == 1 && paper.libs.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(name2);
                        if (m.getType() == 2 || isClass) {
                            dirList[index++] = name2;
                            foundClass |= isClass;
                        }
                        ++i2;
                    }
                }
                if (!foundClass && (container = this.sourceFolder.findMember(qualifiedPackageName)) instanceof IContainer && (members = ((IContainer)container).members()).length > 0) {
                    dirList = new String[members.length];
                    index = 0;
                    i2 = 0;
                    l = members.length;
                    while (i2 < l) {
                        m = members[i2];
                        name2 = m.getName();
                        if (m.getType() == 2 || m.getType() == 1 && paper.libs.org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(name2)) {
                            dirList[index++] = name2;
                        }
                        ++i2;
                    }
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    @Override
    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString() + " with " + super.toString();
    }

    public void acceptModuleInfo(ICompilationUnit cu, Parser parser) {
        CompilationResult compilationResult = new CompilationResult(cu, 0, 1, 10);
        CompilationUnitDeclaration unit = parser.parse(cu, compilationResult);
        if (unit.isModuleInfo() && unit.moduleDeclaration != null) {
            this.module = new BasicModule(unit.moduleDeclaration, null);
        }
    }

    @Override
    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule module() {
        return this.module;
    }
}

