/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import paper.libs.org.eclipse.jdt.core.Flags;
import paper.libs.org.eclipse.jdt.core.ILocalVariable;
import paper.libs.org.eclipse.jdt.core.IMemberValuePair;
import paper.libs.org.eclipse.jdt.core.IMethod;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.ITypeParameter;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.Signature;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Binding;
import paper.libs.org.eclipse.jdt.internal.core.CompilationUnit;
import paper.libs.org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.LocalVariable;
import paper.libs.org.eclipse.jdt.internal.core.NamedMember;
import paper.libs.org.eclipse.jdt.internal.core.ResolvedSourceMethod;
import paper.libs.org.eclipse.jdt.internal.core.SourceAnnotationMethodInfo;
import paper.libs.org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import paper.libs.org.eclipse.jdt.internal.core.TypeParameter;
import paper.libs.org.eclipse.jdt.internal.core.TypeParameterElementInfo;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class SourceMethod
extends NamedMember
implements IMethod {
    protected String[] parameterTypes;

    protected SourceMethod(JavaElement parent, String name2, String[] parameterTypes) {
        super(parent, name2);
        this.parameterTypes = parameterTypes == null ? CharOperation.NO_STRINGS : parameterTypes;
    }

    @Override
    protected void closing(Object info) throws JavaModelException {
        super.closing(info);
        SourceMethodElementInfo elementInfo = (SourceMethodElementInfo)info;
        ITypeParameter[] typeParameters = elementInfo.typeParameters;
        int i2 = 0;
        int length = typeParameters.length;
        while (i2 < length) {
            ((TypeParameter)typeParameters[i2]).close();
            ++i2;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SourceMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.parameterTypes, ((SourceMethod)o).parameterTypes);
    }

    @Override
    public IMemberValuePair getDefaultValue() throws JavaModelException {
        SourceMethodElementInfo sourceMethodInfo = (SourceMethodElementInfo)this.getElementInfo();
        if (sourceMethodInfo.isAnnotationMethod()) {
            return ((SourceAnnotationMethodInfo)sourceMethodInfo).defaultValue;
        }
        return null;
    }

    @Override
    public int getElementType() {
        return 9;
    }

    @Override
    public String[] getExceptionTypes() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] exs = info.getExceptionTypeNames();
        return CompilationUnitStructureRequestor.convertTypeNamesToSigs(exs);
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        this.getParent().getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i2 = 0;
        while (i2 < this.parameterTypes.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.parameterTypes[i2]);
            ++i2;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '~';
    }

    @Override
    public String getKey() {
        try {
            return this.getKey(this, false);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    @Override
    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    @Override
    public String[] getParameterNames() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        return CharOperation.toStrings(names);
    }

    @Override
    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    @Override
    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.typeParameters;
    }

    @Override
    public ILocalVariable[] getParameters() throws JavaModelException {
        ILocalVariable[] arguments = ((SourceMethodElementInfo)this.getElementInfo()).arguments;
        if (arguments == null) {
            return LocalVariable.NO_LOCAL_VARIABLES;
        }
        return arguments;
    }

    @Override
    public String[] getTypeParameterSignatures() throws JavaModelException {
        ITypeParameter[] typeParameters = this.getTypeParameters();
        int length = typeParameters.length;
        String[] typeParameterSignatures = new String[length];
        int i2 = 0;
        while (i2 < length) {
            TypeParameter typeParameter = (TypeParameter)typeParameters[i2];
            TypeParameterElementInfo info = (TypeParameterElementInfo)typeParameter.getElementInfo();
            char[][] bounds = info.bounds;
            if (bounds == null) {
                typeParameterSignatures[i2] = Signature.createTypeParameterSignature(typeParameter.getElementName(), CharOperation.NO_STRINGS);
            } else {
                int boundsLength = bounds.length;
                char[][] boundSignatures = new char[boundsLength][];
                int j = 0;
                while (j < boundsLength) {
                    boundSignatures[j] = Signature.createCharArrayTypeSignature(bounds[j], false);
                    ++j;
                }
                typeParameterSignatures[i2] = new String(Signature.createTypeParameterSignature(typeParameter.getElementName().toCharArray(), boundSignatures));
            }
            ++i2;
        }
        return typeParameterSignatures;
    }

    @Override
    public JavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && (cu = (CompilationUnit)this.getAncestor(5)).isPrimary()) {
            return this;
        }
        JavaElement primaryParent = this.getParent().getPrimaryElement(false);
        return (JavaElement)((Object)((IType)((Object)primaryParent)).getMethod(this.name, this.parameterTypes));
    }

    @Override
    public String[] getRawParameterNames() throws JavaModelException {
        return this.getParameterNames();
    }

    @Override
    public String getReturnType() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(info.getReturnTypeName(), false);
    }

    @Override
    public String getSignature() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createMethodSignature(this.parameterTypes, Signature.createTypeSignature(info.getReturnTypeName(), false));
    }

    @Override
    public int hashCode() {
        int hash2 = super.hashCode();
        int i2 = 0;
        int length = this.parameterTypes.length;
        while (i2 < length) {
            hash2 = Util.combineHashCodes(hash2, this.parameterTypes[i2].hashCode());
            ++i2;
        }
        return hash2;
    }

    @Override
    public boolean isConstructor() throws JavaModelException {
        if (!this.getElementName().equals(this.getParent().getElementName())) {
            return false;
        }
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    @Override
    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    @Override
    public boolean isLambdaMethod() {
        return false;
    }

    @Override
    public boolean isResolved() {
        return false;
    }

    @Override
    public boolean isSimilar(IMethod method) {
        return SourceMethod.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    @Override
    public String readableName() {
        int length;
        StringBuilder buffer = new StringBuilder(super.readableName());
        buffer.append('(');
        if (this.parameterTypes != null && (length = this.parameterTypes.length) > 0) {
            int i2 = 0;
            while (i2 < length) {
                buffer.append(Signature.toString(this.parameterTypes[i2]));
                if (i2 < length - 1) {
                    buffer.append(", ");
                }
                ++i2;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public JavaElement resolved(Binding binding) {
        ResolvedSourceMethod resolvedHandle = new ResolvedSourceMethod(this.getParent(), this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            SourceMethodElementInfo methodInfo = (SourceMethodElementInfo)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append(methodInfo.getReturnTypeName());
                buffer.append(' ');
            }
            this.toStringName(buffer, flags);
        }
    }

    @Override
    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            boolean isVarargs = Flags.isVarargs(flags);
            int i2 = 0;
            while (i2 < length) {
                try {
                    if (i2 < length - 1) {
                        buffer.append(Signature.toString(parameters[i2]));
                        buffer.append(", ");
                    } else if (isVarargs) {
                        String parameter = parameters[i2].substring(1);
                        buffer.append(Signature.toString(parameter));
                        buffer.append(" ...");
                    } else {
                        buffer.append(Signature.toString(parameters[i2]));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i2]);
                }
                ++i2;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }
}

