/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import paper.libs.org.eclipse.jdt.core.BindingKey;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IField;
import paper.libs.org.eclipse.jdt.core.IMember;
import paper.libs.org.eclipse.jdt.core.IMethod;
import paper.libs.org.eclipse.jdt.core.IModularClassFile;
import paper.libs.org.eclipse.jdt.core.IModuleDescription;
import paper.libs.org.eclipse.jdt.core.IPackageFragment;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.ITypeParameter;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.Signature;
import paper.libs.org.eclipse.jdt.core.WorkingCopyOwner;
import paper.libs.org.eclipse.jdt.core.compiler.CategorizedProblem;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import paper.libs.org.eclipse.jdt.internal.codeassist.SelectionEngine;
import paper.libs.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.Member;
import paper.libs.org.eclipse.jdt.internal.core.NameLookup;
import paper.libs.org.eclipse.jdt.internal.core.SearchableEnvironment;

public abstract class NamedMember
extends Member {
    protected String name;

    public NamedMember(JavaElement parent, String name2) {
        super(parent);
        this.name = name2;
    }

    private void appendTypeParameters(StringBuffer buffer) throws JavaModelException {
        ITypeParameter[] typeParameters = this.getTypeParameters();
        int length = typeParameters.length;
        if (length == 0) {
            return;
        }
        buffer.append('<');
        int i2 = 0;
        while (i2 < length) {
            ITypeParameter typeParameter = typeParameters[i2];
            buffer.append(typeParameter.getElementName());
            String[] bounds = typeParameter.getBounds();
            int boundsLength = bounds.length;
            if (boundsLength > 0) {
                buffer.append(" extends ");
                int j = 0;
                while (j < boundsLength) {
                    buffer.append(bounds[j]);
                    if (j < boundsLength - 1) {
                        buffer.append(" & ");
                    }
                    ++j;
                }
            }
            if (i2 < length - 1) {
                buffer.append(", ");
            }
            ++i2;
        }
        buffer.append('>');
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    protected String getKey(IField field, boolean forceOpen) throws JavaModelException {
        StringBuilder key = new StringBuilder();
        String declaringKey = this.getKey((IType)field.getParent(), forceOpen);
        key.append(declaringKey);
        key.append('.');
        key.append(field.getElementName());
        return key.toString();
    }

    protected String getKey(IMethod method, boolean forceOpen) throws JavaModelException {
        ITypeParameter[] typeParameters;
        int length;
        StringBuilder key = new StringBuilder();
        String declaringKey = this.getKey((IType)method.getParent(), forceOpen);
        key.append(declaringKey);
        key.append('.');
        if (!method.isConstructor()) {
            String selector = method.getElementName();
            key.append(selector);
        }
        if (forceOpen && (length = (typeParameters = method.getTypeParameters()).length) > 0) {
            key.append('<');
            int i2 = 0;
            while (i2 < length) {
                ITypeParameter typeParameter = typeParameters[i2];
                String[] bounds = typeParameter.getBounds();
                int boundsLength = bounds.length;
                char[][] boundSignatures = new char[boundsLength][];
                int j = 0;
                while (j < boundsLength) {
                    boundSignatures[j] = Signature.createCharArrayTypeSignature(bounds[j].toCharArray(), method.isBinary());
                    CharOperation.replace(boundSignatures[j], '.', '/');
                    ++j;
                }
                char[] sig = Signature.createTypeParameterSignature(typeParameter.getElementName().toCharArray(), boundSignatures);
                key.append(sig);
                ++i2;
            }
            key.append('>');
        }
        key.append('(');
        String[] parameters = method.getParameterTypes();
        int i3 = 0;
        int length2 = parameters.length;
        while (i3 < length2) {
            key.append(parameters[i3].replace('.', '/'));
            ++i3;
        }
        key.append(')');
        if (forceOpen) {
            key.append(method.getReturnType().replace('.', '/'));
        } else {
            key.append('V');
        }
        return key.toString();
    }

    protected String getKey(IType type, boolean forceOpen) throws JavaModelException {
        StringBuilder key = new StringBuilder();
        key.append('L');
        String packageName = type.getPackageFragment().getElementName();
        key.append(packageName.replace('.', '/'));
        if (packageName.length() > 0) {
            key.append('/');
        }
        String typeQualifiedName = type.getTypeQualifiedName('$');
        ICompilationUnit cu = (ICompilationUnit)type.getAncestor(5);
        if (cu != null) {
            String topLevelTypeName;
            String cuName = cu.getElementName();
            String mainTypeName = cuName.substring(0, cuName.lastIndexOf(46));
            int end = typeQualifiedName.indexOf(36);
            if (end == -1) {
                end = typeQualifiedName.length();
            }
            if (!mainTypeName.equals(topLevelTypeName = typeQualifiedName.substring(0, end))) {
                key.append(mainTypeName);
                key.append('~');
            }
        }
        key.append(typeQualifiedName);
        key.append(';');
        return key.toString();
    }

    protected String getKey(IModuleDescription module, boolean forceOpen) throws JavaModelException {
        StringBuilder key = new StringBuilder();
        key.append('\"');
        String modName = module.getElementName();
        key.append(modName);
        return key.toString();
    }

    protected String getFullyQualifiedParameterizedName(String fullyQualifiedName, String uniqueKey) throws JavaModelException {
        String[] typeArguments = new BindingKey(uniqueKey).getTypeArguments();
        int length = typeArguments.length;
        if (length == 0) {
            return fullyQualifiedName;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(fullyQualifiedName);
        buffer.append('<');
        int i2 = 0;
        while (i2 < length) {
            String typeArgument = typeArguments[i2];
            buffer.append(Signature.toString(typeArgument));
            if (i2 < length - 1) {
                buffer.append(',');
            }
            ++i2;
        }
        buffer.append('>');
        return buffer.toString();
    }

    protected IPackageFragment getPackageFragment() {
        return null;
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaModelException {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator, showParameters);
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator, boolean showParameters) throws JavaModelException {
        NamedMember declaringType;
        switch (this.getParent().getElementType()) {
            case 5: {
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(this.name);
                    this.appendTypeParameters(buffer);
                    return buffer.toString();
                }
                return this.name;
            }
            case 6: {
                if (this.getParent() instanceof IModularClassFile) {
                    return null;
                }
                String classFileName = this.getParent().getElementName();
                String typeName = classFileName.indexOf(36) == -1 ? this.name : classFileName.substring(0, classFileName.lastIndexOf(46)).replace('$', enclosingTypeSeparator);
                if (showParameters) {
                    StringBuffer buffer = new StringBuffer(typeName);
                    this.appendTypeParameters(buffer);
                    return buffer.toString();
                }
                return typeName;
            }
            case 7: {
                declaringType = (NamedMember)this.getParent();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                declaringType = (NamedMember)((Object)((IMember)((Object)this.getParent())).getDeclaringType());
                break;
            }
            default: {
                return null;
            }
        }
        StringBuffer buffer = new StringBuffer(declaringType.getTypeQualifiedName(enclosingTypeSeparator, showParameters));
        buffer.append(enclosingTypeSeparator);
        String simpleName = this.name.length() == 0 ? this.getOccurrenceCountSignature() : this.name;
        buffer.append(simpleName);
        if (showParameters) {
            this.appendTypeParameters(buffer);
        }
        return buffer.toString();
    }

    protected String getOccurrenceCountSignature() {
        return Integer.toString(this.occurrenceCount);
    }

    protected ITypeParameter[] getTypeParameters() throws JavaModelException {
        return null;
    }

    public String[][] resolveType(String typeName) throws JavaModelException {
        return this.resolveType(typeName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public String[][] resolveType(String typeName, WorkingCopyOwner owner) throws JavaModelException {
        JavaProject project = this.getJavaProject();
        SearchableEnvironment environment = project.newSearchableNameEnvironment(owner);
        class TypeResolveRequestor
        implements ISelectionRequestor {
            String[][] answers = null;

            TypeResolveRequestor() {
            }

            @Override
            public void acceptType(char[] packageName, char[] tName, int modifiers, boolean isDeclaration, char[] uniqueKey, int start, int end) {
                String[] answer = new String[]{new String(packageName), new String(tName)};
                if (this.answers == null) {
                    this.answers = new String[][]{answer};
                } else {
                    int length = this.answers.length;
                    this.answers = new String[length + 1][];
                    System.arraycopy(this.answers, 0, this.answers, 0, length);
                    this.answers[length] = answer;
                }
            }

            @Override
            public void acceptError(CategorizedProblem error) {
            }

            @Override
            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] fieldName, boolean isDeclaration, char[] uniqueKey, int start, int end) {
            }

            @Override
            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, String enclosingDeclaringTypeSignature, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, String[] parameterSignatures, char[][] typeParameterNames, char[][][] typeParameterBoundNames, boolean isConstructor, boolean isDeclaration, char[] uniqueKey, int start, int end) {
            }

            @Override
            public void acceptPackage(char[] packageName) {
            }

            @Override
            public void acceptTypeParameter(char[] declaringTypePackageName, char[] declaringTypeName, char[] typeParameterName, boolean isDeclaration, int start, int end) {
            }

            @Override
            public void acceptMethodTypeParameter(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, int selectorStart, int selcetorEnd, char[] typeParameterName, boolean isDeclaration, int start, int end) {
            }

            @Override
            public void acceptModule(char[] moduleName, char[] uniqueKey, int start, int end) {
            }
        }
        TypeResolveRequestor requestor = new TypeResolveRequestor();
        SelectionEngine engine = new SelectionEngine(environment, requestor, project.getOptions(true), owner);
        engine.selectType(typeName.toCharArray(), (IType)((Object)this));
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
        return requestor.answers;
    }
}

