/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.compiler.ast;

import paper.libs.org.eclipse.jdt.internal.compiler.ASTVisitor;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Expression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.IJavadocTypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Scope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocModuleReference
extends Expression
implements IJavadocTypeReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public TypeReference typeReference;
    public ModuleReference moduleReference;
    public ModuleBinding moduleBinding;

    public JavadocModuleReference(char[][] sources, long[] pos, int tagStart, int tagEnd) {
        this.moduleReference = new ModuleReference(sources, pos);
        this.tagSourceStart = tagStart;
        this.tagSourceEnd = tagEnd;
        this.sourceStart = this.moduleReference.sourceStart;
        this.sourceEnd = this.moduleReference.sourceEnd;
        this.bits |= 0x8000;
    }

    public JavadocModuleReference(ModuleReference moduleRef, int tagStart, int tagEnd) {
        this.moduleReference = moduleRef;
        this.tagSourceStart = tagStart;
        this.tagSourceEnd = tagEnd;
        this.sourceStart = this.moduleReference.sourceStart;
        this.sourceEnd = this.moduleReference.sourceEnd;
        this.bits |= 0x8000;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    @Override
    public int getTagSourceStart() {
        return this.tagSourceStart;
    }

    @Override
    public int getTagSourceEnd() {
        return this.tagSourceEnd;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference typeReference) {
        this.typeReference = typeReference;
        if (this.typeReference != null) {
            this.sourceEnd = this.typeReference.sourceEnd;
        }
    }

    public ModuleReference getModuleReference() {
        return this.moduleReference;
    }

    public void setModuleReference(ModuleReference moduleReference) {
        this.moduleReference = moduleReference;
        this.sourceStart = this.moduleReference.sourceStart;
        this.sourceStart = this.moduleReference.sourceEnd;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.moduleReference != null) {
            output.append(this.moduleReference.moduleName);
        }
        output.append('/');
        if (this.typeReference != null) {
            this.typeReference.printExpression(indent, output);
        }
        return output;
    }

    public ModuleBinding resolve(Scope scope) {
        ModuleBinding modBinding = this.moduleReference.resolve(scope);
        if (modBinding != null && !modBinding.isUnnamed() && modBinding.isValidBinding()) {
            this.moduleBinding = modBinding;
        } else {
            this.reportInvalidModule(scope);
        }
        return this.moduleBinding;
    }

    private ModuleBinding resolveModule(BlockScope scope) {
        return this.resolve((Scope)scope);
    }

    private ModuleBinding resolveModule(ClassScope scope) {
        return this.resolve(scope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        this.resolveModule(blockScope);
        TypeBinding tBinding = null;
        if (this.moduleBinding == null) return tBinding;
        if (this.typeReference == null) return tBinding;
        tBinding = this.typeReference.resolveType(blockScope);
        PackageBinding pBinding = null;
        if (tBinding != null) {
            if (!tBinding.isValidBinding()) return tBinding;
            pBinding = tBinding.getPackage();
        } else if (this.typeReference.resolvedType != null && !this.typeReference.resolvedType.isValidBinding()) {
            if (this.typeReference instanceof JavadocSingleTypeReference) {
                pBinding = ((JavadocSingleTypeReference)this.typeReference).packageBinding;
            } else if (this.typeReference instanceof JavadocQualifiedTypeReference) {
                pBinding = ((JavadocQualifiedTypeReference)this.typeReference).packageBinding;
            }
        }
        if (pBinding == null) return tBinding;
        if (this.moduleBinding.equals(pBinding.enclosingModule)) return tBinding;
        this.reportInvalidType(blockScope);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeBinding resolveType(ClassScope classScope) {
        this.resolveModule(classScope);
        TypeBinding tBinding = null;
        if (this.moduleBinding == null) return tBinding;
        if (this.typeReference == null) return tBinding;
        tBinding = this.typeReference.resolveType(classScope, -1);
        PackageBinding pBinding = null;
        if (tBinding != null) {
            if (!tBinding.isValidBinding()) return tBinding;
            pBinding = tBinding.getPackage();
        } else if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
            if (this.typeReference instanceof JavadocSingleTypeReference) {
                pBinding = ((JavadocSingleTypeReference)this.typeReference).packageBinding;
            } else if (this.typeReference instanceof JavadocQualifiedTypeReference) {
                pBinding = ((JavadocQualifiedTypeReference)this.typeReference).packageBinding;
            }
        }
        if (pBinding == null) return tBinding;
        if (this.moduleBinding.equals(pBinding.enclosingModule)) return tBinding;
        this.reportInvalidType(classScope);
        return null;
    }

    protected void reportInvalidModule(Scope scope) {
        scope.problemReporter().javadocInvalidModule(this.moduleReference);
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().javadocInvalidMemberTypeQualification(this.typeReference.sourceStart, this.typeReference.sourceEnd, scope.getDeclarationModifiers());
    }
}

