/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.codeassist.complete;

import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionNodeFound;
import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionOnJavadocAllocationExpression;
import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionOnJavadocMessageSend;
import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionOnJavadocModuleReference;
import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionOnJavadocParamNameReference;
import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionOnJavadocQualifiedTypeReference;
import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionOnJavadocTag;
import paper.libs.org.eclipse.jdt.internal.codeassist.complete.CompletionOnJavadocTypeParamReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Argument;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Expression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Javadoc;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Binding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Scope;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class CompletionJavadoc
extends Javadoc {
    Expression completionNode;

    public CompletionJavadoc(int sourceStart, int sourceEnd) {
        super(sourceStart, sourceEnd);
    }

    public Expression getCompletionNode() {
        return this.completionNode;
    }

    private void internalResolve(Scope scope) {
        if (this.completionNode != null) {
            CompletionOnJavadocModuleReference modRef;
            TypeReference tRef;
            if (this.completionNode instanceof CompletionOnJavadocTag) {
                ((CompletionOnJavadocTag)this.completionNode).filterPossibleTags(scope);
            } else {
                boolean resolve = true;
                if (this.completionNode instanceof CompletionOnJavadocParamNameReference) {
                    resolve = ((CompletionOnJavadocParamNameReference)this.completionNode).token != null;
                } else if (this.completionNode instanceof CompletionOnJavadocTypeParamReference) {
                    boolean bl = resolve = ((CompletionOnJavadocTypeParamReference)this.completionNode).token != null;
                }
                if (resolve) {
                    switch (scope.kind) {
                        case 3: {
                            this.completionNode.resolveType((ClassScope)scope);
                            break;
                        }
                        case 2: {
                            this.completionNode.resolveType((MethodScope)scope);
                        }
                    }
                }
                if (this.completionNode instanceof CompletionOnJavadocParamNameReference) {
                    CompletionOnJavadocParamNameReference paramNameReference = (CompletionOnJavadocParamNameReference)this.completionNode;
                    if (scope.kind == 2) {
                        paramNameReference.missingParams = this.missingParamTags(paramNameReference.binding, (MethodScope)scope);
                    }
                    if (paramNameReference.token == null || paramNameReference.token.length == 0) {
                        paramNameReference.missingTypeParams = this.missingTypeParameterTags(paramNameReference.binding, scope);
                    }
                } else if (this.completionNode instanceof CompletionOnJavadocTypeParamReference) {
                    CompletionOnJavadocTypeParamReference typeParamReference = (CompletionOnJavadocTypeParamReference)this.completionNode;
                    typeParamReference.missingParams = this.missingTypeParameterTags(typeParamReference.resolvedType, scope);
                }
            }
            Binding qualifiedBinding = null;
            CompletionOnJavadocQualifiedTypeReference completionOnJavadocQualifiedTypeReference = null;
            if (this.completionNode instanceof CompletionOnJavadocModuleReference && (tRef = (modRef = (CompletionOnJavadocModuleReference)this.completionNode).getTypeReference()) instanceof CompletionOnJavadocQualifiedTypeReference) {
                completionOnJavadocQualifiedTypeReference = (CompletionOnJavadocQualifiedTypeReference)tRef;
            }
            if (this.completionNode instanceof CompletionOnJavadocQualifiedTypeReference) {
                completionOnJavadocQualifiedTypeReference = (CompletionOnJavadocQualifiedTypeReference)this.completionNode;
            }
            if (completionOnJavadocQualifiedTypeReference != null) {
                qualifiedBinding = completionOnJavadocQualifiedTypeReference.packageBinding == null ? completionOnJavadocQualifiedTypeReference.resolvedType : completionOnJavadocQualifiedTypeReference.packageBinding;
            } else if (this.completionNode instanceof CompletionOnJavadocMessageSend) {
                CompletionOnJavadocMessageSend msg = (CompletionOnJavadocMessageSend)this.completionNode;
                if (!msg.receiver.isThis()) {
                    qualifiedBinding = msg.receiver.resolvedType;
                }
            } else if (this.completionNode instanceof CompletionOnJavadocAllocationExpression) {
                CompletionOnJavadocAllocationExpression alloc = (CompletionOnJavadocAllocationExpression)this.completionNode;
                qualifiedBinding = alloc.type.resolvedType;
            }
            throw new CompletionNodeFound((ASTNode)this.completionNode, qualifiedBinding, scope);
        }
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        int length;
        int i2;
        CompletionJavadoc.printIndent(indent, output).append("/**\n");
        boolean nodePrinted = false;
        if (this.paramReferences != null) {
            i2 = 0;
            length = this.paramReferences.length;
            while (i2 < length) {
                CompletionJavadoc.printIndent(indent, output).append(" * @param ");
                this.paramReferences[i2].print(indent, output).append('\n');
                if (!nodePrinted && this.completionNode != null) {
                    nodePrinted = this.completionNode == this.paramReferences[i2];
                }
                ++i2;
            }
        }
        if (this.paramTypeParameters != null) {
            i2 = 0;
            length = this.paramTypeParameters.length;
            while (i2 < length) {
                CompletionJavadoc.printIndent(indent, output).append(" * @param <");
                this.paramTypeParameters[i2].print(indent, output).append(">\n");
                if (!nodePrinted && this.completionNode != null) {
                    nodePrinted = this.completionNode == this.paramTypeParameters[i2];
                }
                ++i2;
            }
        }
        if (this.returnStatement != null) {
            CompletionJavadoc.printIndent(indent, output).append(" * @");
            this.returnStatement.print(indent, output).append('\n');
        }
        if (this.exceptionReferences != null) {
            i2 = 0;
            length = this.exceptionReferences.length;
            while (i2 < length) {
                CompletionJavadoc.printIndent(indent, output).append(" * @throws ");
                this.exceptionReferences[i2].print(indent, output).append('\n');
                if (!nodePrinted && this.completionNode != null) {
                    nodePrinted = this.completionNode == this.exceptionReferences[i2];
                }
                ++i2;
            }
        }
        if (this.seeReferences != null) {
            i2 = 0;
            length = this.seeReferences.length;
            while (i2 < length) {
                CompletionJavadoc.printIndent(indent, output).append(" * @see ");
                this.seeReferences[i2].print(indent, output).append('\n');
                if (!nodePrinted && this.completionNode != null) {
                    nodePrinted = this.completionNode == this.seeReferences[i2];
                }
                ++i2;
            }
        }
        if (!nodePrinted && this.completionNode != null) {
            CompletionJavadoc.printIndent(indent, output).append(" * ");
            this.completionNode.print(indent, output).append('\n');
        }
        CompletionJavadoc.printIndent(indent, output).append(" */\n");
        return output;
    }

    @Override
    public void resolve(ClassScope scope) {
        super.resolve(scope);
        this.internalResolve(scope);
    }

    @Override
    public void resolve(CompilationUnitScope scope) {
        this.internalResolve(scope);
    }

    @Override
    public void resolve(MethodScope scope) {
        super.resolve(scope);
        this.internalResolve(scope);
    }

    private char[][] missingParamTags(Binding paramNameRefBinding, MethodScope methScope) {
        int argumentsSize;
        int paramTagsSize;
        AbstractMethodDeclaration md = methScope.referenceMethod();
        int n = paramTagsSize = this.paramReferences == null ? 0 : this.paramReferences.length;
        if (md == null) {
            return null;
        }
        int n2 = argumentsSize = md.arguments == null ? 0 : md.arguments.length;
        if (argumentsSize == 0) {
            return null;
        }
        if (paramTagsSize == 0) {
            char[][] missingParams = new char[argumentsSize][];
            int i2 = 0;
            while (i2 < argumentsSize) {
                missingParams[i2] = md.arguments[i2].name;
                ++i2;
            }
            return missingParams;
        }
        char[][] missingParams = new char[argumentsSize][];
        int size = 0;
        int i3 = 0;
        while (i3 < argumentsSize) {
            Argument arg = md.arguments[i3];
            boolean found = false;
            int paramNameRefCount = 0;
            int j = 0;
            while (j < paramTagsSize && !found) {
                JavadocSingleNameReference param = this.paramReferences[j];
                if (arg.binding == param.binding) {
                    found = param.binding == paramNameRefBinding ? ++paramNameRefCount > 1 : true;
                }
                ++j;
            }
            if (!found) {
                missingParams[size++] = arg.name;
            }
            ++i3;
        }
        if (size > 0) {
            if (size != argumentsSize) {
                char[][] cArrayArray = missingParams;
                missingParams = new char[size][];
                System.arraycopy(cArrayArray, 0, missingParams, 0, size);
            }
            return missingParams;
        }
        return null;
    }

    private char[][] missingTypeParameterTags(Binding paramNameRefBinding, Scope scope) {
        int paramTypeParamLength = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
        TypeParameter[] parameters = null;
        TypeVariableBinding[] typeVariables = null;
        switch (scope.kind) {
            case 2: {
                AbstractMethodDeclaration methodDeclaration = ((MethodScope)scope).referenceMethod();
                if (methodDeclaration == null) {
                    return null;
                }
                parameters = methodDeclaration.typeParameters();
                typeVariables = methodDeclaration.binding.typeVariables;
                break;
            }
            case 3: {
                TypeDeclaration typeDeclaration = ((ClassScope)scope).referenceContext;
                parameters = typeDeclaration.typeParameters;
                typeVariables = typeDeclaration.binding.typeVariables;
            }
        }
        if (typeVariables == null || typeVariables.length == 0) {
            return null;
        }
        if (parameters != null) {
            char[][] missingParams;
            int typeParametersLength = parameters.length;
            if (paramTypeParamLength == 0) {
                missingParams = new char[typeParametersLength][];
                int i2 = 0;
                while (i2 < typeParametersLength) {
                    missingParams[i2] = parameters[i2].name;
                    ++i2;
                }
                return missingParams;
            }
            missingParams = new char[typeParametersLength][];
            int size = 0;
            int i3 = 0;
            while (i3 < typeParametersLength) {
                TypeParameter parameter = parameters[i3];
                boolean found = false;
                int paramNameRefCount = 0;
                int j = 0;
                while (j < paramTypeParamLength && !found) {
                    if (TypeBinding.equalsEquals(parameter.binding, this.paramTypeParameters[j].resolvedType)) {
                        found = parameter.binding == paramNameRefBinding ? ++paramNameRefCount > 1 : true;
                    }
                    ++j;
                }
                if (!found) {
                    missingParams[size++] = parameter.name;
                }
                ++i3;
            }
            if (size > 0) {
                if (size != typeParametersLength) {
                    char[][] cArrayArray = missingParams;
                    missingParams = new char[size][];
                    System.arraycopy(cArrayArray, 0, missingParams, 0, size);
                }
                return missingParams;
            }
        }
        return null;
    }
}

