/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.runtime.internal.adaptor;

import paper.libs.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.BundleException;
import paper.libs.org.osgi.framework.ServiceReference;
import paper.libs.org.osgi.service.packageadmin.PackageAdmin;

public class ConsoleManager {
    public static final String PROP_CONSOLE = "osgi.console";
    public static final String CONSOLE_BUNDLE = "paper.libs.org.eclipse.equinox.console";
    public static final String PROP_CONSOLE_ENABLED = "osgi.console.enable.builtin";
    private final BundleContext context;
    private final String consoleBundle;
    private final String consolePort;

    public ConsoleManager(BundleContext context, EquinoxConfiguration equinoxConfig) {
        String port = null;
        String consolePropValue = equinoxConfig.getConfiguration(PROP_CONSOLE);
        if (consolePropValue != null) {
            int index = consolePropValue.lastIndexOf(":");
            port = consolePropValue.substring(index + 1);
        }
        this.consolePort = port != null ? port.trim() : port;
        String enabled = equinoxConfig.getConfiguration(PROP_CONSOLE_ENABLED, CONSOLE_BUNDLE).trim();
        if ("true".equals(enabled) || "false".equals(enabled)) {
            enabled = CONSOLE_BUNDLE;
        }
        this.consoleBundle = enabled;
        this.context = context;
    }

    public static ConsoleManager startConsole(BundleContext context, EquinoxConfiguration equinoxConfig) {
        ConsoleManager consoleManager = new ConsoleManager(context, equinoxConfig);
        return consoleManager;
    }

    public void checkForConsoleBundle() throws BundleException {
        if ("none".equals(this.consolePort)) {
            return;
        }
        ServiceReference<PackageAdmin> paRef = this.context.getServiceReference(PackageAdmin.class);
        PackageAdmin pa = paRef == null ? null : this.context.getService(paRef);
        Bundle[] consoles = pa.getBundles(this.consoleBundle, null);
        if (consoles == null || consoles.length == 0) {
            if (this.consolePort != null) {
                throw new BundleException("Could not find bundle: " + this.consoleBundle, 1);
            }
            return;
        }
        try {
            consoles[0].start(1);
        }
        catch (BundleException e) {
            throw new BundleException("Could not start bundle: " + this.consoleBundle, 1, e);
        }
    }

    public void stopConsole() {
    }
}

