/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import paper.libs.org.eclipse.core.internal.content.ContentMessages;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;
import paper.libs.org.eclipse.core.runtime.IExecutableExtension;
import paper.libs.org.eclipse.core.runtime.QualifiedName;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.content.IContentDescriber;
import paper.libs.org.eclipse.core.runtime.content.IContentDescription;
import paper.libs.org.eclipse.osgi.util.NLS;

public final class BinarySignatureDescriber
implements IContentDescriber,
IExecutableExtension {
    private static final String SIGNATURE = "signature";
    private static final String OFFSET = "offset";
    private static final Object REQUIRED = "required";
    private byte[] signature;
    private int offset;
    private boolean required = true;

    @Override
    public int describe(InputStream contents2, IContentDescription description) throws IOException {
        int notValid;
        byte[] buffer = new byte[this.signature.length];
        int n = notValid = this.required ? 0 : 1;
        if (contents2.skip(this.offset) < (long)this.offset) {
            return notValid;
        }
        if (contents2.read(buffer) != buffer.length) {
            return notValid;
        }
        int i2 = 0;
        while (i2 < this.signature.length) {
            if (this.signature[i2] != buffer[i2]) {
                return notValid;
            }
            ++i2;
        }
        return 2;
    }

    @Override
    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }

    @Override
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            if (data instanceof String) {
                this.signature = BinarySignatureDescriber.parseSignature((String)data);
            } else if (data instanceof Hashtable) {
                Hashtable parameters = (Hashtable)data;
                if (!parameters.containsKey(SIGNATURE)) {
                    String message = NLS.bind(ContentMessages.content_badInitializationData, BinarySignatureDescriber.class.getName());
                    throw new CoreException(new Status(4, "paper.libs.org.eclipse.core.contenttype", 0, message, null));
                }
                this.signature = BinarySignatureDescriber.parseSignature((String)parameters.get(SIGNATURE));
                if (parameters.containsKey(OFFSET)) {
                    this.offset = Integer.parseInt((String)parameters.get(OFFSET));
                }
                if (parameters.containsKey(REQUIRED)) {
                    this.required = Boolean.parseBoolean((String)parameters.get(REQUIRED));
                }
            }
        }
        catch (NumberFormatException nfe) {
            String message = NLS.bind(ContentMessages.content_badInitializationData, BinarySignatureDescriber.class.getName());
            throw new CoreException(new Status(4, "paper.libs.org.eclipse.core.contenttype", 0, message, (Throwable)nfe));
        }
    }

    private static byte[] parseSignature(String data) {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        StringTokenizer tokenizer = new StringTokenizer(data, " \t\n\r\f,");
        while (tokenizer.hasMoreTokens()) {
            bytes.add((byte)Integer.parseInt(tokenizer.nextToken().trim(), 16));
        }
        byte[] signature = new byte[bytes.size()];
        int i2 = 0;
        while (i2 < signature.length) {
            signature[i2] = (Byte)bytes.get(i2);
            ++i2;
        }
        return signature;
    }
}

