/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.runtime;

import java.util.HashSet;
import java.util.Set;
import paper.libs.org.eclipse.core.internal.runtime.RuntimeLog;
import paper.libs.org.eclipse.core.internal.runtime.TracingOptions;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.NullProgressMonitor;
import paper.libs.org.eclipse.core.runtime.OperationCanceledException;
import paper.libs.org.eclipse.core.runtime.Status;

public final class SubMonitor
implements IProgressMonitorWithBlocking {
    private static final int TRIVIAL_SPLITS_BEFORE_CANCELLATION_CHECK = 20;
    private static final int TRIVIAL_OPERATION_COUNT_LIMIT = 20;
    private static final int TRIVIAL_SPLIT_DELTA = 1;
    private static final int MINIMUM_RESOLUTION = 1000;
    private int totalParent;
    private int usedForParent = 0;
    private double usedForChildren = 0.0;
    private int totalForChildren;
    private SubMonitor lastSubMonitor;
    private final RootInfo root;
    private final int flags;
    private boolean beginTaskCalled;
    private boolean ticksAllocated;
    public static final int SUPPRESS_SUBTASK = 1;
    public static final int SUPPRESS_BEGINTASK = 2;
    public static final int SUPPRESS_SETTASKNAME = 4;
    public static final int SUPPRESS_ISCANCELED = 8;
    public static final int SUPPRESS_ALL_LABELS = 7;
    public static final int SUPPRESS_NONE = 0;
    private static final int ALL_PUBLIC_FLAGS = 15;
    private static final int ALL_INHERITED_FLAGS = 9;
    private static final Set<String> knownBuggyMethods = new HashSet<String>();

    private SubMonitor(RootInfo rootInfo, int totalWork, int availableToChildren, int flags) {
        this.root = rootInfo;
        this.totalParent = totalWork > 0 ? totalWork : 0;
        this.totalForChildren = availableToChildren;
        this.flags = flags;
        this.ticksAllocated = availableToChildren > 0;
    }

    public static SubMonitor convert(IProgressMonitor monitor) {
        return SubMonitor.convert(monitor, "", 0);
    }

    public static SubMonitor convert(IProgressMonitor monitor, int work) {
        return SubMonitor.convert(monitor, "", work);
    }

    public static SubMonitor convert(IProgressMonitor monitor, String taskName, int work) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
            return new SubMonitor(new RootInfo(monitor), 0, work, 7);
        }
        if (monitor instanceof SubMonitor) {
            SubMonitor subMonitor = (SubMonitor)monitor;
            subMonitor.beginTaskImpl(taskName, work);
            return subMonitor;
        }
        monitor.beginTask(taskName, 1000);
        return new SubMonitor(new RootInfo(monitor), 1000, work, 0);
    }

    public static void done(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    public SubMonitor setWorkRemaining(int workRemaining) {
        if (TracingOptions.debugProgressMonitors && this.ticksAllocated && this.usedForChildren >= (double)this.totalForChildren && workRemaining > 0) {
            SubMonitor.logProblem("Attempted to allocate ticks on a SubMonitor which had no space available. This may indicate that a SubMonitor was reused inappropriately (which is a bug) or may indicate that the caller was implementing infinite progress and overflowed (which may not be a bug but may require selecting a higher ratio)");
        }
        if (workRemaining > 0) {
            this.ticksAllocated = true;
        } else {
            workRemaining = 0;
        }
        if (this.totalForChildren > 0 && this.totalParent > this.usedForParent) {
            double remainForParent = (double)this.totalParent * (1.0 - this.usedForChildren / (double)this.totalForChildren);
            this.usedForChildren = (double)workRemaining * (1.0 - remainForParent / (double)(this.totalParent - this.usedForParent));
        } else {
            this.usedForChildren = 0.0;
        }
        this.totalParent -= this.usedForParent;
        this.usedForParent = 0;
        this.totalForChildren = workRemaining;
        return this;
    }

    private int consume(double ticks) {
        if (TracingOptions.debugProgressMonitors && !this.ticksAllocated && ticks > 0.0) {
            SubMonitor.logProblem("You must allocate ticks using beginTask or setWorkRemaining before trying to consume them");
        }
        if (this.totalParent == 0 || this.totalForChildren == 0) {
            return 0;
        }
        this.usedForChildren += ticks;
        if (this.usedForChildren > (double)this.totalForChildren) {
            this.usedForChildren = this.totalForChildren;
            if (TracingOptions.debugProgressMonitors) {
                SubMonitor.logProblem("This progress monitor consumed more ticks than were allocated for it.");
            }
        } else if (this.usedForChildren < 0.0) {
            this.usedForChildren = 0.0;
        }
        int parentPosition = (int)((double)this.totalParent * this.usedForChildren / (double)this.totalForChildren);
        int delta = parentPosition - this.usedForParent;
        this.usedForParent = parentPosition;
        return delta;
    }

    @Override
    public boolean isCanceled() {
        if ((this.flags & 8) == 0) {
            return this.root.isCanceled();
        }
        return false;
    }

    public SubMonitor checkCanceled() throws OperationCanceledException {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        return this;
    }

    @Override
    public void setTaskName(String name2) {
        if ((this.flags & 4) == 0) {
            this.root.setTaskName(name2);
        }
    }

    @Override
    public void beginTask(String name2, int totalWork) {
        if (TracingOptions.debugProgressMonitors && this.beginTaskCalled) {
            SubMonitor.logProblem("beginTask was called on this instance more than once");
        }
        this.beginTaskImpl(name2, totalWork);
    }

    private void beginTaskImpl(String name2, int totalWork) {
        if ((this.flags & 2) == 0 && name2 != null) {
            this.root.setTaskName(name2);
        }
        this.setWorkRemaining(totalWork);
        this.beginTaskCalled = true;
    }

    @Override
    public void done() {
        this.cleanupActiveChild();
        int delta = this.totalParent - this.usedForParent;
        if (delta > 0) {
            this.root.worked(delta);
        }
        this.totalParent = 0;
        this.usedForParent = 0;
        this.totalForChildren = 0;
        this.usedForChildren = 0.0;
    }

    @Override
    public void internalWorked(double work) {
        this.cleanupActiveChild();
        int delta = this.consume(work > 0.0 ? work : 0.0);
        if (delta != 0) {
            this.root.worked(delta);
        }
    }

    @Override
    public void subTask(String name2) {
        if ((this.flags & 1) == 0) {
            this.root.subTask(name2);
        }
    }

    @Override
    public void worked(int work) {
        if (TracingOptions.debugProgressMonitors && work == 0) {
            SubMonitor.logProblem("Attempted to report 0 ticks of work");
        }
        this.internalWorked(work);
    }

    @Override
    public void setCanceled(boolean b) {
        this.root.setCanceled(b);
    }

    public SubMonitor newChild(int totalWork) {
        return this.newChild(totalWork, 2);
    }

    public SubMonitor newChild(int totalWork, int suppressFlags) {
        SubMonitor result;
        double totalWorkDouble = totalWork > 0 ? (double)totalWork : 0.0;
        totalWorkDouble = Math.min(totalWorkDouble, (double)this.totalForChildren - this.usedForChildren);
        SubMonitor oldActiveChild = this.lastSubMonitor;
        this.cleanupActiveChild();
        int childFlags = this.flags & 9;
        if ((this.flags & 4) != 0) {
            childFlags |= 6;
        }
        childFlags |= suppressFlags & 0xF;
        int consumed = this.consume(totalWorkDouble);
        if (TracingOptions.debugProgressMonitors) {
            if (totalWork == 0) {
                SubMonitor.logProblem("Attempted to create a child without providing it with any ticks");
            }
        } else {
            if (consumed == 0 && oldActiveChild != null && childFlags == oldActiveChild.flags) {
                this.lastSubMonitor = oldActiveChild;
                return oldActiveChild;
            }
            if (this.usedForParent >= this.totalParent && childFlags == this.flags) {
                this.totalParent = consumed;
                this.usedForParent = 0;
                this.totalForChildren = 0;
                this.usedForChildren = 0.0;
                return this;
            }
        }
        this.lastSubMonitor = result = new SubMonitor(this.root, consumed, 0, childFlags);
        return result;
    }

    public SubMonitor split(int totalWork) throws OperationCanceledException {
        return this.split(totalWork, 2);
    }

    public SubMonitor split(int totalWork, int suppressFlags) throws OperationCanceledException {
        int oldUsedForParent = this.usedForParent;
        SubMonitor result = this.newChild(totalWork, suppressFlags);
        if ((result.flags & 8) == 0) {
            int ticksTheChildWillReportToParent = result.totalParent;
            if (ticksTheChildWillReportToParent > 0) {
                if (oldUsedForParent > 0 || this.usedForParent < this.totalParent) {
                    this.root.checkForCancellation();
                }
            } else {
                this.root.reportTrivialOperation(1);
            }
        }
        return result;
    }

    private void cleanupActiveChild() {
        SubMonitor child = this.lastSubMonitor;
        if (child == null) {
            return;
        }
        this.lastSubMonitor = null;
        child.done();
    }

    @Override
    public void clearBlocked() {
        this.root.clearBlocked();
    }

    @Override
    public void setBlocked(IStatus reason) {
        this.root.setBlocked(reason);
    }

    protected static boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private static String getCallerName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String ourClassName = SubMonitor.class.getCanonicalName();
        int idx = 1;
        while (idx < stackTrace.length) {
            String className = stackTrace[idx].getClassName();
            if (!className.equals(ourClassName)) {
                return stackTrace[idx].toString();
            }
            ++idx;
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logProblem(String message) {
        String caller = SubMonitor.getCallerName();
        Set<String> set = knownBuggyMethods;
        synchronized (set) {
            if (!knownBuggyMethods.add(caller)) {
                return;
            }
        }
        RuntimeLog.log(new Status(2, "paper.libs.org.eclipse.core.runtime", message, new Throwable()));
    }

    public String toString() {
        return "SubMonitor [totalParent=" + this.totalParent + ", usedForParent=" + this.usedForParent + ", usedForChildren=" + this.usedForChildren + ", totalForChildren=" + this.totalForChildren + ", beginTaskCalled=" + this.beginTaskCalled + "]";
    }

    private static final class RootInfo {
        final IProgressMonitor root;
        String taskName;
        String subTask;
        int cancellationCheckCounter;

        public RootInfo(IProgressMonitor root) {
            this.root = root;
        }

        public boolean isCanceled() {
            return this.root.isCanceled();
        }

        public void setCanceled(boolean value) {
            this.root.setCanceled(value);
        }

        public void setTaskName(String taskName) {
            if (SubMonitor.eq(taskName, this.taskName)) {
                return;
            }
            this.taskName = taskName;
            this.root.setTaskName(taskName);
        }

        public void subTask(String name2) {
            if (SubMonitor.eq(this.subTask, name2)) {
                return;
            }
            this.subTask = name2;
            this.root.subTask(name2);
        }

        public void worked(int i2) {
            this.root.worked(i2);
        }

        public void clearBlocked() {
            this.root.clearBlocked();
        }

        public void setBlocked(IStatus reason) {
            this.root.setBlocked(reason);
        }

        public void checkForCancellation() {
            if (this.root.isCanceled()) {
                throw new OperationCanceledException();
            }
        }

        public void reportTrivialOperation(int cancellationDelta) {
            this.cancellationCheckCounter += cancellationDelta;
            if (this.cancellationCheckCounter >= 20) {
                this.cancellationCheckCounter = 0;
                this.checkForCancellation();
            }
        }
    }
}

