/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.runtime;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Properties;
import paper.libs.org.eclipse.core.internal.preferences.PreferencesService;
import paper.libs.org.eclipse.core.internal.preferences.PrefsMessages;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.ISafeRunnable;
import paper.libs.org.eclipse.core.runtime.IStatus;
import paper.libs.org.eclipse.core.runtime.ListenerList;
import paper.libs.org.eclipse.core.runtime.SafeRunner;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.preferences.IEclipsePreferences;
import paper.libs.org.eclipse.osgi.util.NLS;

@Deprecated
public class Preferences {
    public static final boolean BOOLEAN_DEFAULT_DEFAULT = false;
    public static final double DOUBLE_DEFAULT_DEFAULT = 0.0;
    public static final float FLOAT_DEFAULT_DEFAULT = 0.0f;
    public static final int INT_DEFAULT_DEFAULT = 0;
    public static final long LONG_DEFAULT_DEFAULT = 0L;
    public static final String STRING_DEFAULT_DEFAULT = "";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String PT_PREFERENCES = "preferences";
    protected ListenerList<IPropertyChangeListener> listeners = new ListenerList();
    private Properties properties;
    private Properties defaultProperties = new Properties();
    protected boolean dirty = false;

    public static void exportPreferences(IPath path) throws CoreException {
        File file = path.toFile();
        if (file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        PreferencesService service = PreferencesService.getDefault();
        OutputStream output = null;
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(file);
                output = new BufferedOutputStream(fos);
                IEclipsePreferences node = (IEclipsePreferences)service.getRootNode().node("instance");
                service.exportPreferences(node, output, null);
                output.flush();
                fos.getFD().sync();
            }
            catch (IOException e) {
                String message = NLS.bind(PrefsMessages.preferences_errorWriting, file, e.getMessage());
                Status status = new Status(4, "paper.libs.org.eclipse.equinox.preferences", 4, message, (Throwable)e);
                throw new CoreException(status);
            }
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void importPreferences(IPath path) throws CoreException {
        if (!path.toFile().exists()) {
            String msg = NLS.bind(PrefsMessages.preferences_fileNotFound, path.toOSString());
            throw new CoreException(new Status(4, "paper.libs.org.eclipse.equinox.preferences", 1, msg, null));
        }
        PreferencesService service = PreferencesService.getDefault();
        InputStream input = null;
        try {
            try {
                input = new BufferedInputStream(new FileInputStream(path.toFile()));
                service.importPreferences(input);
            }
            catch (FileNotFoundException e) {
                String msg = NLS.bind(PrefsMessages.preferences_fileNotFound, path.toOSString());
                throw new CoreException(new Status(4, "paper.libs.org.eclipse.equinox.preferences", 1, msg, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static IStatus validatePreferenceVersions(IPath file) {
        PreferencesService service = PreferencesService.getDefault();
        return service.validateVersions(file);
    }

    public Preferences() {
        this.properties = new Properties(this.defaultProperties);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean contains(String name2) {
        return this.properties.containsKey(name2) || this.defaultProperties.containsKey(name2);
    }

    protected void firePropertyChangeEvent(String name2, Object oldValue, Object newValue) {
        if (name2 == null) {
            throw new IllegalArgumentException();
        }
        if (this.listeners.size() == 0) {
            return;
        }
        final PropertyChangeEvent pe = new PropertyChangeEvent(this, name2, oldValue, newValue);
        for (final IPropertyChangeListener l : this.listeners) {
            ISafeRunnable job = new ISafeRunnable(){

                @Override
                public void handleException(Throwable exception) {
                }

                @Override
                public void run() throws Exception {
                    l.propertyChange(pe);
                }
            };
            SafeRunner.run(job);
        }
    }

    public boolean getBoolean(String name2) {
        String value = this.properties.getProperty(name2);
        if (value == null) {
            return false;
        }
        return value.equals(TRUE);
    }

    public void setValue(String name2, boolean value) {
        boolean defaultValue = this.getDefaultBoolean(name2);
        boolean oldValue = this.getBoolean(name2);
        if (value == defaultValue) {
            Object removed = this.properties.remove(name2);
            if (removed != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(name2, value ? TRUE : FALSE);
        }
        if (oldValue != value) {
            this.dirty = true;
            this.firePropertyChangeEvent(name2, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getDefaultBoolean(String name2) {
        String value = this.defaultProperties.getProperty(name2);
        if (value == null) {
            return false;
        }
        return value.equals(TRUE);
    }

    public void setDefault(String name2, boolean value) {
        this.defaultProperties.put(name2, value ? TRUE : FALSE);
    }

    public double getDouble(String name2) {
        return this.convertToDouble(this.properties.getProperty(name2), 0.0);
    }

    public void setValue(String name2, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        double defaultValue = this.getDefaultDouble(name2);
        double oldValue = this.getDouble(name2);
        if (value == defaultValue) {
            Object removed = this.properties.remove(name2);
            if (removed != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(name2, Double.toString(value));
        }
        if (oldValue != value) {
            this.dirty = true;
            this.firePropertyChangeEvent(name2, oldValue, value);
        }
    }

    public double getDefaultDouble(String name2) {
        return this.convertToDouble(this.defaultProperties.getProperty(name2), 0.0);
    }

    public void setDefault(String name2, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        this.defaultProperties.put(name2, Double.toString(value));
    }

    private double convertToDouble(String rawPropertyValue, double defaultValue) {
        double result = defaultValue;
        if (rawPropertyValue != null) {
            try {
                result = Double.parseDouble(rawPropertyValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public float getFloat(String name2) {
        return this.convertToFloat(this.properties.getProperty(name2), 0.0f);
    }

    public void setValue(String name2, float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        float defaultValue = this.getDefaultFloat(name2);
        float oldValue = this.getFloat(name2);
        if (value == defaultValue) {
            Object removed = this.properties.remove(name2);
            if (removed != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(name2, Float.toString(value));
        }
        if (oldValue != value) {
            this.dirty = true;
            this.firePropertyChangeEvent(name2, Float.valueOf(oldValue), Float.valueOf(value));
        }
    }

    public float getDefaultFloat(String name2) {
        return this.convertToFloat(this.defaultProperties.getProperty(name2), 0.0f);
    }

    public void setDefault(String name2, float value) {
        if (Float.isNaN(value)) {
            throw new IllegalArgumentException();
        }
        this.defaultProperties.put(name2, Float.toString(value));
    }

    private float convertToFloat(String rawPropertyValue, float defaultValue) {
        float result = defaultValue;
        if (rawPropertyValue != null) {
            try {
                result = Float.parseFloat(rawPropertyValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public int getInt(String name2) {
        return this.convertToInt(this.properties.getProperty(name2), 0);
    }

    public void setValue(String name2, int value) {
        int defaultValue = this.getDefaultInt(name2);
        int oldValue = this.getInt(name2);
        if (value == defaultValue) {
            Object removed = this.properties.remove(name2);
            if (removed != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(name2, Integer.toString(value));
        }
        if (oldValue != value) {
            this.dirty = true;
            this.firePropertyChangeEvent(name2, oldValue, value);
        }
    }

    public int getDefaultInt(String name2) {
        return this.convertToInt(this.defaultProperties.getProperty(name2), 0);
    }

    public void setDefault(String name2, int value) {
        this.defaultProperties.put(name2, Integer.toString(value));
    }

    private int convertToInt(String rawPropertyValue, int defaultValue) {
        int result = defaultValue;
        if (rawPropertyValue != null) {
            try {
                result = Integer.parseInt(rawPropertyValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public long getLong(String name2) {
        return this.convertToLong(this.properties.getProperty(name2), 0L);
    }

    public void setValue(String name2, long value) {
        long defaultValue = this.getDefaultLong(name2);
        long oldValue = this.getLong(name2);
        if (value == defaultValue) {
            Object removed = this.properties.remove(name2);
            if (removed != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(name2, Long.toString(value));
        }
        if (oldValue != value) {
            this.dirty = true;
            this.firePropertyChangeEvent(name2, oldValue, value);
        }
    }

    public long getDefaultLong(String name2) {
        return this.convertToLong(this.defaultProperties.getProperty(name2), 0L);
    }

    public void setDefault(String name2, long value) {
        this.defaultProperties.put(name2, Long.toString(value));
    }

    private long convertToLong(String rawPropertyValue, long defaultValue) {
        long result = defaultValue;
        if (rawPropertyValue != null) {
            try {
                result = Long.parseLong(rawPropertyValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public String getString(String name2) {
        String value = this.properties.getProperty(name2);
        return value != null ? value : STRING_DEFAULT_DEFAULT;
    }

    public void setValue(String name2, String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        String defaultValue = this.getDefaultString(name2);
        String oldValue = this.getString(name2);
        if (value.equals(defaultValue)) {
            Object removed = this.properties.remove(name2);
            if (removed != null) {
                this.dirty = true;
            }
        } else {
            this.properties.put(name2, value);
        }
        if (!oldValue.equals(value)) {
            this.dirty = true;
            this.firePropertyChangeEvent(name2, oldValue, value);
        }
    }

    public String getDefaultString(String name2) {
        String value = this.defaultProperties.getProperty(name2);
        return value != null ? value : STRING_DEFAULT_DEFAULT;
    }

    public void setDefault(String name2, String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.defaultProperties.put(name2, value);
    }

    public boolean isDefault(String name2) {
        return !this.properties.containsKey(name2);
    }

    public void setToDefault(String name2) {
        Object oldPropertyValue = this.properties.remove(name2);
        if (oldPropertyValue != null) {
            this.dirty = true;
        }
        String newValue = this.defaultProperties.getProperty(name2, null);
        this.firePropertyChangeEvent(name2, oldPropertyValue, newValue);
    }

    public String[] propertyNames() {
        return this.properties.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String[] defaultPropertyNames() {
        return this.defaultProperties.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public void store(OutputStream out, String header) throws IOException {
        this.properties.store(out, header);
        this.dirty = false;
    }

    public void load(InputStream in) throws IOException {
        this.properties.load(in);
        this.dirty = false;
    }

    @FunctionalInterface
    public static interface IPropertyChangeListener
    extends EventListener {
        public void propertyChange(PropertyChangeEvent var1);
    }

    public static class PropertyChangeEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private String propertyName;
        private Object oldValue;
        private Object newValue;

        protected PropertyChangeEvent(Object source, String property, Object oldValue, Object newValue) {
            super(source);
            if (property == null) {
                throw new IllegalArgumentException();
            }
            this.propertyName = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public String getProperty() {
            return this.propertyName;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public Object getOldValue() {
            return this.oldValue;
        }
    }
}

