/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.runtime;

import java.util.Objects;
import java.util.Optional;
import paper.libs.org.eclipse.core.internal.runtime.AdapterManager;
import paper.libs.org.eclipse.core.internal.runtime.CommonMessages;
import paper.libs.org.eclipse.core.internal.runtime.RuntimeLog;
import paper.libs.org.eclipse.core.runtime.AssertionFailedException;
import paper.libs.org.eclipse.core.runtime.IAdaptable;
import paper.libs.org.eclipse.core.runtime.PlatformObject;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.osgi.util.NLS;

public class Adapters {
    public static <T> T adapt(Object sourceObject, Class<T> adapter, boolean allowActivation) {
        IAdaptable adaptable;
        Object result;
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return (T)sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException(String.valueOf(adaptable.getClass().getName()) + ".getAdapter(" + adapter.getName() + ".class) returned " + result.getClass().getName() + " that is not an instance the requested type");
            }
            return (T)result;
        }
        if (sourceObject instanceof PlatformObject && !allowActivation) {
            return null;
        }
        String adapterId = adapter.getName();
        result = Adapters.queryAdapterManager(sourceObject, adapterId, allowActivation);
        if (result != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException("An adapter factory for " + sourceObject.getClass().getName() + " returned " + result.getClass().getName() + " that is not an instance of " + adapter.getName());
            }
            return (T)result;
        }
        return null;
    }

    public static <T> T adapt(Object sourceObject, Class<T> adapter) {
        return Adapters.adapt(sourceObject, adapter, true);
    }

    public static <T> Optional<T> of(Object sourceObject, Class<T> adapter) {
        if (sourceObject == null) {
            return Optional.empty();
        }
        Objects.requireNonNull(adapter);
        try {
            return Optional.ofNullable(Adapters.adapt(sourceObject, adapter));
        }
        catch (AssertionFailedException e) {
            RuntimeLog.log(Status.error(NLS.bind(CommonMessages.adapters_internal_error_of, new Object[]{sourceObject.getClass().getName(), adapter.getClass().getName(), e.getLocalizedMessage()}), e));
            return Optional.empty();
        }
    }

    private static Object queryAdapterManager(Object sourceObject, String adapterId, boolean allowActivation) {
        Object result = allowActivation ? AdapterManager.getDefault().loadAdapter(sourceObject, adapterId) : AdapterManager.getDefault().getAdapter(sourceObject, adapterId);
        return result;
    }
}

