/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.utils;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.GregorianCalendar;
import java.util.Random;

public class UniversalUniqueIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] fBits = new byte[16];
    private static BigInteger fgPreviousClockValue;
    private static int fgClockAdjustment;
    private static int fgClockSequence;
    private static byte[] nodeAddress;
    private static Random fgRandomNumberGenerator;
    public static final int BYTES_SIZE = 16;
    public static final byte[] UNDEFINED_UUID_BYTES;
    public static final int MAX_CLOCK_SEQUENCE = 16384;
    public static final int MAX_CLOCK_ADJUSTMENT = Short.MAX_VALUE;
    public static final int TIME_FIELD_START = 0;
    public static final int TIME_FIELD_STOP = 6;
    public static final int TIME_HIGH_AND_VERSION = 7;
    public static final int CLOCK_SEQUENCE_HIGH_AND_RESERVED = 8;
    public static final int CLOCK_SEQUENCE_LOW = 9;
    public static final int NODE_ADDRESS_START = 10;
    public static final int NODE_ADDRESS_BYTE_SIZE = 6;
    public static final int BYTE_MASK = 255;
    public static final int HIGH_NIBBLE_MASK = 240;
    public static final int LOW_NIBBLE_MASK = 15;
    public static final int SHIFT_NIBBLE = 4;
    public static final int ShiftByte = 8;

    static {
        fgClockAdjustment = 0;
        fgClockSequence = -1;
        nodeAddress = UniversalUniqueIdentifier.computeNodeAddress();
        fgRandomNumberGenerator = new Random();
        UNDEFINED_UUID_BYTES = new byte[16];
    }

    public UniversalUniqueIdentifier() {
        this.setVersion(1);
        this.setVariant(1);
        this.setTimeValues();
        this.setNode(UniversalUniqueIdentifier.getNodeAddress());
    }

    public UniversalUniqueIdentifier(byte[] byteValue) {
        this.fBits = new byte[16];
        if (byteValue.length >= 16) {
            System.arraycopy(byteValue, 0, this.fBits, 0, 16);
        }
    }

    private void appendByteString(StringBuilder buffer, byte value) {
        String hexString = value < 0 ? Integer.toHexString(256 + value) : Integer.toHexString(value);
        if (hexString.length() == 1) {
            buffer.append("0");
        }
        buffer.append(hexString);
    }

    private static BigInteger clockValueNow() {
        GregorianCalendar now = new GregorianCalendar();
        BigInteger nowMillis = BigInteger.valueOf(now.getTime().getTime());
        BigInteger baseMillis = BigInteger.valueOf(now.getGregorianChange().getTime());
        return nowMillis.subtract(baseMillis).multiply(BigInteger.valueOf(10000L));
    }

    public static int compareTime(byte[] fBits1, byte[] fBits2) {
        int i2 = 6;
        while (i2 >= 0) {
            if (fBits1[i2] != fBits2[i2]) {
                return (0xFF & fBits1[i2]) - (0xFF & fBits2[i2]);
            }
            --i2;
        }
        return 0;
    }

    private static byte[] computeNodeAddress() {
        byte[] address = new byte[6];
        SecureRandom randomizer = new SecureRandom();
        randomizer.nextBytes(address);
        address[0] = (byte)(address[0] | 0xFFFFFF80);
        return address;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UniversalUniqueIdentifier)) {
            return false;
        }
        byte[] other = ((UniversalUniqueIdentifier)obj).fBits;
        if (this.fBits == other) {
            return true;
        }
        if (this.fBits.length != other.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.fBits.length) {
            if (this.fBits[i2] != other[i2]) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static byte[] getNodeAddress() {
        return nodeAddress;
    }

    public int hashCode() {
        return this.fBits[0] + this.fBits[3] + this.fBits[7] + this.fBits[11] + this.fBits[15];
    }

    private static int nextClockSequence() {
        if (fgClockSequence == -1) {
            fgClockSequence = (int)(fgRandomNumberGenerator.nextDouble() * 16384.0);
        }
        fgClockSequence = (fgClockSequence + 1) % 16384;
        return fgClockSequence;
    }

    private static BigInteger nextTimestamp() {
        BigInteger timestamp = UniversalUniqueIdentifier.clockValueNow();
        int timestampComparison = timestamp.compareTo(fgPreviousClockValue);
        if (timestampComparison == 0) {
            if (fgClockAdjustment == Short.MAX_VALUE) {
                while (timestamp.compareTo(fgPreviousClockValue) == 0) {
                    timestamp = UniversalUniqueIdentifier.clockValueNow();
                }
                timestamp = UniversalUniqueIdentifier.nextTimestamp();
            } else {
                ++fgClockAdjustment;
            }
        } else {
            fgClockAdjustment = 0;
            if (timestampComparison < 0) {
                UniversalUniqueIdentifier.nextClockSequence();
            }
        }
        return timestamp;
    }

    private void setClockSequence(int clockSeq) {
        int clockSeqHigh = clockSeq >>> 8 & 0xF;
        int reserved = this.fBits[8] & 0xF0;
        this.fBits[8] = (byte)(reserved | clockSeqHigh);
        this.fBits[9] = (byte)(clockSeq & 0xFF);
    }

    protected void setNode(byte[] bytes) {
        System.arraycopy(bytes, 0, this.fBits, 10, 6);
    }

    private void setTimestamp(BigInteger timestamp) {
        BigInteger value = timestamp;
        BigInteger bigByte = BigInteger.valueOf(256L);
        int index = 0;
        while (index < 6) {
            BigInteger[] results = value.divideAndRemainder(bigByte);
            value = results[0];
            this.fBits[index] = (byte)results[1].intValue();
            ++index;
        }
        int version = this.fBits[7] & 0xF0;
        int timeHigh = value.intValue() & 0xF;
        this.fBits[7] = (byte)(timeHigh | version);
    }

    protected synchronized void setTimeValues() {
        this.setTimestamp(UniversalUniqueIdentifier.timestamp());
        this.setClockSequence(fgClockSequence);
    }

    protected int setVariant(int variantIdentifier) {
        int clockSeqHigh = this.fBits[8] & 0xF;
        int variant = variantIdentifier & 0xF;
        this.fBits[8] = (byte)(variant << 4 | clockSeqHigh);
        return variant;
    }

    protected void setVersion(int versionIdentifier) {
        int timeHigh = this.fBits[7] & 0xF;
        int version = versionIdentifier & 0xF;
        this.fBits[7] = (byte)(timeHigh | version << 4);
    }

    private static BigInteger timestamp() {
        BigInteger timestamp;
        if (fgPreviousClockValue == null) {
            fgClockAdjustment = 0;
            UniversalUniqueIdentifier.nextClockSequence();
            timestamp = UniversalUniqueIdentifier.clockValueNow();
        } else {
            timestamp = UniversalUniqueIdentifier.nextTimestamp();
        }
        fgPreviousClockValue = timestamp;
        return fgClockAdjustment == 0 ? timestamp : timestamp.add(BigInteger.valueOf(fgClockAdjustment));
    }

    public byte[] toBytes() {
        byte[] result = new byte[this.fBits.length];
        System.arraycopy(this.fBits, 0, result, 0, this.fBits.length);
        return result;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        byte[] byArray2 = this.fBits;
        int n = this.fBits.length;
        int n2 = 0;
        while (n2 < n) {
            byte bit = byArray2[n2];
            this.appendByteString(buffer, bit);
            ++n2;
        }
        return buffer.toString();
    }

    public String toStringAsBytes() {
        StringBuilder result = new StringBuilder("{");
        int i2 = 0;
        while (i2 < this.fBits.length) {
            result.append(this.fBits[i2]);
            if (i2 < this.fBits.length + 1) {
                result.append(',');
            }
            ++i2;
        }
        result.append('}');
        return result.toString();
    }
}

