/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.resources;

import java.util.ArrayList;
import paper.libs.org.eclipse.core.internal.resources.ResourceException;
import paper.libs.org.eclipse.core.internal.utils.Messages;
import paper.libs.org.eclipse.core.resources.IProjectNatureDescriptor;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;
import paper.libs.org.eclipse.core.runtime.IExtension;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.osgi.util.NLS;

public class ProjectNatureDescriptor
implements IProjectNatureDescriptor {
    protected String id;
    protected String label;
    protected String[] requiredNatures;
    protected String[] natureSets;
    protected String[] builderIds;
    protected String[] contentTypeIds;
    protected boolean allowLinking = true;
    protected boolean hasCycle = false;
    protected byte colour = 0;

    protected ProjectNatureDescriptor(IExtension natureExtension) throws CoreException {
        this.readExtension(natureExtension);
    }

    protected void fail() throws CoreException {
        this.fail(NLS.bind(Messages.natures_invalidDefinition, this.id));
    }

    protected void fail(String reason) throws CoreException {
        throw new ResourceException(new Status(4, "paper.libs.org.eclipse.core.resources", 1, reason, null));
    }

    public String[] getBuilderIds() {
        return this.builderIds;
    }

    public String[] getContentTypeIds() {
        return this.contentTypeIds;
    }

    @Override
    public String getNatureId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String[] getRequiredNatureIds() {
        return this.requiredNatures;
    }

    @Override
    public String[] getNatureSetIds() {
        return this.natureSets;
    }

    @Override
    public boolean isLinkingAllowed() {
        return this.allowLinking;
    }

    protected void readExtension(IExtension natureExtension) throws CoreException {
        this.id = natureExtension.getUniqueIdentifier();
        if (this.id == null) {
            this.fail(Messages.natures_missingIdentifier);
        }
        this.label = natureExtension.getLabel();
        IConfigurationElement[] elements = natureExtension.getConfigurationElements();
        int count = elements.length;
        ArrayList<String> requiredList = new ArrayList<String>(count);
        ArrayList<String> setList = new ArrayList<String>(count);
        ArrayList<String> builderList = new ArrayList<String>(count);
        ArrayList<String> contentTypeList = new ArrayList<String>(count);
        int i2 = 0;
        while (i2 < count) {
            String attribute;
            IConfigurationElement element = elements[i2];
            String name2 = element.getName();
            if (name2.equalsIgnoreCase("requires-nature")) {
                attribute = element.getAttribute("id");
                if (attribute == null) {
                    this.fail();
                }
                requiredList.add(attribute);
            } else if (name2.equalsIgnoreCase("one-of-nature")) {
                attribute = element.getAttribute("id");
                if (attribute == null) {
                    this.fail();
                }
                setList.add(attribute);
            } else if (name2.equalsIgnoreCase("builder")) {
                attribute = element.getAttribute("id");
                if (attribute == null) {
                    this.fail();
                }
                builderList.add(attribute);
            } else if (name2.equalsIgnoreCase("content-type")) {
                attribute = element.getAttribute("id");
                if (attribute == null) {
                    this.fail();
                }
                contentTypeList.add(attribute);
            } else if (name2.equalsIgnoreCase("options")) {
                attribute = element.getAttribute("allowLinking");
                this.allowLinking = !Boolean.FALSE.toString().equalsIgnoreCase(attribute);
            }
            ++i2;
        }
        this.requiredNatures = requiredList.toArray(new String[requiredList.size()]);
        this.natureSets = setList.toArray(new String[setList.size()]);
        this.builderIds = builderList.toArray(new String[builderList.size()]);
        this.contentTypeIds = contentTypeList.toArray(new String[contentTypeList.size()]);
    }

    public String toString() {
        return "ProjectNatureDescriptor(" + this.id + ")";
    }
}

