/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.SAXParserFactory;
import paper.libs.org.eclipse.core.internal.registry.ExtensionRegistry;
import paper.libs.org.eclipse.core.internal.registry.ReferenceMap;
import paper.libs.org.eclipse.core.internal.registry.RegistryMessages;
import paper.libs.org.eclipse.core.internal.registry.RegistryProperties;
import paper.libs.org.eclipse.core.internal.registry.RegistryTimestamp;
import paper.libs.org.eclipse.core.internal.registry.osgi.Activator;
import paper.libs.org.eclipse.core.internal.registry.osgi.EclipseBundleListener;
import paper.libs.org.eclipse.core.internal.registry.osgi.OSGIUtils;
import paper.libs.org.eclipse.core.internal.runtime.ResourceTranslator;
import paper.libs.org.eclipse.core.runtime.ContributorFactoryOSGi;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IContributor;
import paper.libs.org.eclipse.core.runtime.IExtensionRegistry;
import paper.libs.org.eclipse.core.runtime.InvalidRegistryObjectException;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.spi.RegistryContributor;
import paper.libs.org.eclipse.core.runtime.spi.RegistryStrategy;
import paper.libs.org.eclipse.osgi.service.localization.LocaleProvider;
import paper.libs.org.eclipse.osgi.util.NLS;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.util.tracker.ServiceTracker;

public class RegistryStrategyOSGI
extends RegistryStrategy {
    private final Object token;
    protected boolean DEBUG;
    protected boolean DEBUG_REGISTRY_EVENTS;
    private ServiceTracker<?, ?> xmlTracker = null;
    private ServiceTracker<?, ?> localeTracker = null;
    private boolean trackTimestamp;
    private static float DEFAULT_BUNDLECACHE_LOADFACTOR = 0.75f;
    private static int DEFAULT_BUNDLECACHE_SIZE = 200;
    private final ReferenceMap bundleMap = new ReferenceMap(1, DEFAULT_BUNDLECACHE_SIZE, DEFAULT_BUNDLECACHE_LOADFACTOR);
    private final ReadWriteLock bundleMapLock = new ReentrantReadWriteLock();
    private EclipseBundleListener pluginBundleListener = null;

    public RegistryStrategyOSGI(File[] theStorageDir, boolean[] cacheReadOnly, Object key) {
        super(theStorageDir, cacheReadOnly);
        this.token = key;
        BundleContext context = Activator.getContext();
        this.trackTimestamp = context != null ? "true".equalsIgnoreCase(context.getProperty("osgi.checkConfiguration")) : false;
    }

    @Override
    public final String translate(String key, ResourceBundle resources) {
        return ResourceTranslator.getResourceString(null, key, resources);
    }

    @Override
    public String[] translate(String[] nonTranslated, IContributor contributor, String locale) {
        return ResourceTranslator.getResourceString(ContributorFactoryOSGi.resolve(contributor), nonTranslated, locale);
    }

    private Bundle getBundle(String id) {
        Bundle bundle;
        long OSGiId;
        if (id == null) {
            return null;
        }
        try {
            OSGiId = Long.parseLong(id);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        this.bundleMapLock.readLock().lock();
        try {
            bundle = (Bundle)this.bundleMap.get((int)OSGiId);
        }
        finally {
            this.bundleMapLock.readLock().unlock();
        }
        if (bundle != null) {
            return bundle;
        }
        bundle = Activator.getContext().getBundle(OSGiId);
        this.bundleMapLock.writeLock().lock();
        try {
            this.bundleMap.put((int)OSGiId, bundle);
        }
        finally {
            this.bundleMapLock.writeLock().unlock();
        }
        return bundle;
    }

    @Override
    public Object createExecutableExtension(RegistryContributor contributor, String className, String overridenContributorName) throws CoreException {
        Bundle contributingBundle = overridenContributorName != null && !overridenContributorName.equals("") ? OSGIUtils.getDefault().getBundle(overridenContributorName) : this.getBundle(contributor.getId());
        if (contributingBundle == null) {
            this.throwException(NLS.bind(RegistryMessages.plugin_loadClassError, "UNKNOWN BUNDLE", className), new InvalidRegistryObjectException());
        }
        Class<?> classInstance = null;
        try {
            classInstance = contributingBundle.loadClass(className);
        }
        catch (Exception | LinkageError e1) {
            this.throwException(NLS.bind(RegistryMessages.plugin_loadClassError, contributingBundle.getSymbolicName(), className), e1);
        }
        Object result = null;
        try {
            result = classInstance.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception | LinkageError e) {
            this.throwException(NLS.bind(RegistryMessages.plugin_instantiateClassError, contributingBundle.getSymbolicName(), className), e);
        }
        return result;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        throw new CoreException(new Status(4, "paper.libs.org.eclipse.equinox.registry", 1, message, exception));
    }

    @Override
    public void onStart(IExtensionRegistry registry, boolean loadedFromCache) {
        super.onStart(registry, loadedFromCache);
        if (!(registry instanceof ExtensionRegistry)) {
            return;
        }
        this.pluginBundleListener = new EclipseBundleListener((ExtensionRegistry)registry, this.token, this);
        Activator.getContext().addBundleListener(this.pluginBundleListener);
        if (!loadedFromCache) {
            this.pluginBundleListener.processBundles(Activator.getContext().getBundles());
        }
    }

    @Override
    public void onStop(IExtensionRegistry registry) {
        if (this.pluginBundleListener != null) {
            Activator.getContext().removeBundleListener(this.pluginBundleListener);
        }
        if (this.xmlTracker != null) {
            this.xmlTracker.close();
            this.xmlTracker = null;
        }
        if (this.localeTracker != null) {
            this.localeTracker.close();
            this.localeTracker = null;
        }
        super.onStop(registry);
    }

    @Override
    public boolean cacheUse() {
        return !"true".equals(RegistryProperties.getProperty("eclipse.noRegistryCache"));
    }

    @Override
    public boolean cacheLazyLoading() {
        return !"true".equalsIgnoreCase(RegistryProperties.getProperty("eclipse.noLazyRegistryCacheLoading"));
    }

    @Override
    public long getContributionsTimestamp() {
        Bundle[] allBundles;
        if (!this.checkContributionsTimestamp()) {
            return 0L;
        }
        RegistryTimestamp expectedTimestamp = new RegistryTimestamp();
        BundleContext context = Activator.getContext();
        Bundle[] bundleArray = allBundles = context.getBundles();
        int n = allBundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            URL pluginManifest = EclipseBundleListener.getExtensionURL(b, false);
            if (pluginManifest != null) {
                long timestamp = this.getExtendedTimestamp(b, pluginManifest);
                expectedTimestamp.add(timestamp);
            }
            ++n2;
        }
        return expectedTimestamp.getContentsTimestamp();
    }

    public boolean checkContributionsTimestamp() {
        return this.trackTimestamp;
    }

    public long getExtendedTimestamp(Bundle bundle, URL pluginManifest) {
        if (pluginManifest == null) {
            return 0L;
        }
        try {
            return pluginManifest.openConnection().getLastModified() + bundle.getBundleId();
        }
        catch (IOException e) {
            if (this.debug()) {
                System.out.println("Unable to obtain timestamp for the bundle " + bundle.getSymbolicName());
                e.printStackTrace();
            }
            return 0L;
        }
    }

    @Override
    public SAXParserFactory getXMLParser() {
        if (this.xmlTracker == null) {
            this.xmlTracker = new ServiceTracker(Activator.getContext(), SAXParserFactory.class.getName(), null);
            this.xmlTracker.open();
        }
        return (SAXParserFactory)this.xmlTracker.getService();
    }

    @Override
    public String getLocale() {
        Locale currentLocale;
        LocaleProvider localeProvider;
        if (this.localeTracker == null) {
            this.localeTracker = new ServiceTracker(Activator.getContext(), LocaleProvider.class.getName(), null);
            this.localeTracker.open();
        }
        if ((localeProvider = (LocaleProvider)this.localeTracker.getService()) != null && (currentLocale = localeProvider.getLocale()) != null) {
            return currentLocale.toString();
        }
        return super.getLocale();
    }
}

