/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.preferences;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import paper.libs.org.eclipse.core.internal.preferences.DefaultPreferences;
import paper.libs.org.eclipse.core.internal.preferences.EclipsePreferences;
import paper.libs.org.eclipse.core.internal.preferences.PreferencesService;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class BundleDefaultPreferences
extends EclipsePreferences {
    private static Set<String> loadedNodes = Collections.synchronizedSet(new HashSet());
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;

    public BundleDefaultPreferences() {
        this(null, null);
    }

    private BundleDefaultPreferences(EclipsePreferences parent, String name2) {
        super(parent, name2);
        Path path = new Path(this.absolutePath());
        this.segmentCount = path.segmentCount();
        if (this.segmentCount < 2) {
            return;
        }
        String scope = path.segment(0);
        if ("bundle_defaults".equals(scope)) {
            this.qualifier = path.segment(1);
        }
        if (this.qualifier == null) {
            return;
        }
    }

    @Override
    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            IEclipsePreferences node = this;
            int i2 = 2;
            while (i2 < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i2;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    @Override
    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    @Override
    protected void loaded() {
        loadedNodes.add(this.name());
    }

    @Override
    protected void load() {
        String relativePath = DefaultPreferences.getScopeRelativePath(this.absolutePath());
        if (relativePath != null) {
            PreferencesService.getDefault().getRootNode().node("default").node(relativePath);
        }
    }

    @Override
    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        return new BundleDefaultPreferences(nodeParent, nodeName);
    }
}

