/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.expressions;

import paper.libs.org.eclipse.core.expressions.IPropertyTester;
import paper.libs.org.eclipse.core.expressions.PropertyTester;
import paper.libs.org.eclipse.core.internal.expressions.ExpressionMessages;
import paper.libs.org.eclipse.core.internal.expressions.ExpressionStatus;
import paper.libs.org.eclipse.core.internal.expressions.PropertyTesterDescriptor;
import paper.libs.org.eclipse.core.internal.expressions.TypeExtensionManager;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.CoreException;

public class TypeExtension {
    private static final TypeExtension[] EMPTY_TYPE_EXTENSION_ARRAY = new TypeExtension[0];
    static final IPropertyTester CONTINUE = new IPropertyTester(){

        @Override
        public boolean handles(String namespace, String method) {
            return false;
        }

        @Override
        public boolean isInstantiated() {
            return true;
        }

        @Override
        public boolean isDeclaringPluginActive() {
            return true;
        }

        @Override
        public IPropertyTester instantiate() {
            return this;
        }

        @Override
        public boolean test(Object receiver, String method, Object[] args, Object expectedValue) {
            return false;
        }
    };
    private static final TypeExtension END_POINT = new TypeExtension(){

        @Override
        IPropertyTester findTypeExtender(TypeExtensionManager manager, String namespace, String name2, boolean staticMethod, boolean forcePluginActivation) throws CoreException {
            return CONTINUE;
        }
    };
    private Class<?> fType;
    private IPropertyTester[] fExtenders;
    private TypeExtension fExtends;
    private TypeExtension[] fImplements;

    private TypeExtension() {
    }

    TypeExtension(Class<?> type) {
        Assert.isNotNull(type);
        this.fType = type;
    }

    IPropertyTester findTypeExtender(TypeExtensionManager manager, String namespace, String method, boolean staticMethod, boolean forcePluginActivation) throws CoreException {
        IPropertyTester result;
        if (this.fExtenders == null) {
            this.fExtenders = manager.loadTesters(this.fType);
        }
        int i2 = 0;
        while (i2 < this.fExtenders.length) {
            IPropertyTester extender = this.fExtenders[i2];
            if (extender != null && extender.handles(namespace, method)) {
                if (extender.isInstantiated()) {
                    return extender;
                }
                if (extender.isDeclaringPluginActive() || forcePluginActivation) {
                    try {
                        PropertyTesterDescriptor descriptor = (PropertyTesterDescriptor)extender;
                        IPropertyTester inst = descriptor.instantiate();
                        ((PropertyTester)inst).internalInitialize(descriptor);
                        this.fExtenders[i2] = extender = inst;
                        return extender;
                    }
                    catch (CoreException e) {
                        this.fExtenders[i2] = null;
                        throw e;
                    }
                    catch (ClassCastException e) {
                        this.fExtenders[i2] = null;
                        throw new CoreException(new ExpressionStatus(202, ExpressionMessages.TypeExtender_incorrectType, e));
                    }
                }
                return extender;
            }
            ++i2;
        }
        if (staticMethod) {
            return CONTINUE;
        }
        if (this.fExtends == null) {
            Class<?> superClass = this.fType.getSuperclass();
            this.fExtends = superClass != null ? manager.get(superClass) : END_POINT;
        }
        if ((result = this.fExtends.findTypeExtender(manager, namespace, method, staticMethod, forcePluginActivation)) != CONTINUE) {
            return result;
        }
        if (this.fImplements == null) {
            Class<?>[] interfaces = this.fType.getInterfaces();
            if (interfaces.length == 0) {
                this.fImplements = EMPTY_TYPE_EXTENSION_ARRAY;
            } else {
                this.fImplements = new TypeExtension[interfaces.length];
                int i3 = 0;
                while (i3 < interfaces.length) {
                    this.fImplements[i3] = manager.get(interfaces[i3]);
                    ++i3;
                }
            }
        }
        TypeExtension[] typeExtensionArray = this.fImplements;
        int n = this.fImplements.length;
        int n2 = 0;
        while (n2 < n) {
            TypeExtension fImplement = typeExtensionArray[n2];
            result = fImplement.findTypeExtender(manager, namespace, method, staticMethod, forcePluginActivation);
            if (result != CONTINUE) {
                return result;
            }
            ++n2;
        }
        return CONTINUE;
    }
}

