/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.expressions;

import org.w3c.dom.Element;
import paper.libs.org.eclipse.core.expressions.EvaluationResult;
import paper.libs.org.eclipse.core.expressions.Expression;
import paper.libs.org.eclipse.core.expressions.ExpressionInfo;
import paper.libs.org.eclipse.core.expressions.IEvaluationContext;
import paper.libs.org.eclipse.core.internal.expressions.Expressions;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;

public class InstanceofExpression
extends Expression {
    private static final int HASH_INITIAL = InstanceofExpression.class.getName().hashCode();
    private String fTypeName;

    public InstanceofExpression(IConfigurationElement element) throws CoreException {
        this.fTypeName = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fTypeName);
    }

    public InstanceofExpression(Element element) throws CoreException {
        this.fTypeName = element.getAttribute("value");
        Expressions.checkAttribute("value", this.fTypeName.isEmpty() ? null : this.fTypeName);
    }

    public InstanceofExpression(String typeName) {
        Assert.isNotNull(typeName);
        this.fTypeName = typeName;
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) {
        Object element = context.getDefaultVariable();
        return EvaluationResult.valueOf(Expressions.isInstanceOf(element, this.fTypeName));
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        info.markDefaultVariableAccessed();
    }

    public boolean equals(Object object) {
        if (!(object instanceof InstanceofExpression)) {
            return false;
        }
        InstanceofExpression that = (InstanceofExpression)object;
        return this.fTypeName.equals(that.fTypeName);
    }

    @Override
    protected int computeHashCode() {
        return HASH_INITIAL * 89 + this.fTypeName.hashCode();
    }

    public String toString() {
        return "<instanceof value=\"" + this.fTypeName + "\"/>";
    }
}

