/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.dtree;

import java.io.DataOutput;
import java.io.IOException;
import paper.libs.org.eclipse.core.internal.dtree.AbstractDataTree;
import paper.libs.org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import paper.libs.org.eclipse.core.internal.dtree.IDataFlattener;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.Path;

public class DataTreeWriter {
    protected IDataFlattener flatener;
    protected DataOutput output;
    public static final int D_INFINITE = -1;

    public DataTreeWriter(IDataFlattener f) {
        this.flatener = f;
    }

    protected void writeNode(AbstractDataTreeNode node, IPath path, int depth) throws IOException {
        int type = node.type();
        String name2 = node.getName();
        if (name2 == null) {
            name2 = "";
        }
        this.output.writeUTF(name2);
        this.writeNumber(type);
        if (node.hasData()) {
            Object data = node.getData();
            if (data == null) {
                this.writeNumber(0);
            } else {
                this.writeNumber(1);
                this.flatener.writeData(path, node.getData(), this.output);
            }
        }
        if (depth > 0 || depth == -1) {
            AbstractDataTreeNode[] children = node.getChildren();
            this.writeNumber(children.length);
            int newDepth = depth == -1 ? -1 : depth - 1;
            AbstractDataTreeNode[] abstractDataTreeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDataTreeNode element = abstractDataTreeNodeArray[n2];
                this.writeNode(element, path.append(element.getName()), newDepth);
                ++n2;
            }
        } else {
            this.writeNumber(0);
        }
    }

    protected void writeNumber(int number) throws IOException {
        if (number >= 0 && number < 255) {
            this.output.writeByte(number);
        } else {
            this.output.writeByte(255);
            this.output.writeInt(number);
        }
    }

    protected void writeSingleNode(AbstractDataTreeNode node, IPath path) throws IOException {
        String name2 = node.getName();
        if (name2 == null) {
            name2 = "";
        }
        this.output.writeUTF(name2);
        this.writeNumber(node.type());
        if (node.hasData()) {
            Object data = node.getData();
            if (data == null) {
                this.writeNumber(0);
            } else {
                this.writeNumber(1);
                this.flatener.writeData(path, node.getData(), this.output);
            }
        }
    }

    public void writeTree(AbstractDataTree tree, IPath path, int depth, DataOutput output) throws IOException {
        String[] segments;
        this.output = output;
        AbstractDataTreeNode node = tree.getRootNode();
        IPath currentPath = Path.ROOT;
        String[] stringArray = segments = path.segments();
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String nextSegment = stringArray[n2];
            this.writeSingleNode(node, currentPath);
            currentPath = currentPath.append(nextSegment);
            node = node.childAtOrNull(nextSegment);
            if (node == null) {
                this.writeNumber(0);
                return;
            }
            this.writeNumber(1);
            ++n2;
        }
        Assert.isTrue(currentPath.equals(path), "dtree.navigationError");
        this.writeNode(node, path, depth);
    }
}

