/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.content;

import java.util.List;
import paper.libs.org.eclipse.core.internal.content.ContentMessages;
import paper.libs.org.eclipse.core.internal.content.ContentType;
import paper.libs.org.eclipse.core.internal.content.ContentTypeManager;
import paper.libs.org.eclipse.core.internal.content.IContentTypeInfo;
import paper.libs.org.eclipse.core.internal.content.Util;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.QualifiedName;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.core.runtime.content.IContentDescription;
import paper.libs.org.eclipse.core.runtime.content.IContentTypeSettings;
import paper.libs.org.eclipse.core.runtime.preferences.IEclipsePreferences;
import paper.libs.org.eclipse.core.runtime.preferences.IScopeContext;
import paper.libs.org.eclipse.osgi.util.NLS;
import paper.libs.org.osgi.service.prefs.BackingStoreException;
import paper.libs.org.osgi.service.prefs.Preferences;

public class ContentTypeSettings
implements IContentTypeSettings,
IContentTypeInfo {
    private ContentType contentType;
    private IScopeContext context;

    static void addFileSpec(IScopeContext context, String contentTypeId, String fileSpec, int type) throws CoreException {
        Preferences contentTypeNode = ContentTypeManager.getInstance().getPreferences(context).node(contentTypeId);
        String key = ContentType.getPreferenceKey(type);
        List<String> existingValues = Util.parseItemsIntoList(contentTypeNode.get(key, null));
        for (String existingValue : existingValues) {
            if (!existingValue.equalsIgnoreCase(fileSpec)) continue;
            return;
        }
        existingValues.add(fileSpec);
        String newValue = Util.toListString(existingValues.toArray());
        ContentType.setPreference(contentTypeNode, key, newValue);
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = NLS.bind(ContentMessages.content_errorSavingSettings, contentTypeId);
            Status status = new Status(4, "paper.libs.org.eclipse.core.contenttype", 0, message, (Throwable)bse);
            throw new CoreException(status);
        }
    }

    static String[] getFileSpecs(IScopeContext context, String contentTypeId, int type) {
        Preferences contentTypeNode = ContentTypeManager.getInstance().getPreferences(context).node(contentTypeId);
        return ContentTypeSettings.getFileSpecs(contentTypeNode, type);
    }

    static String[] getFileSpecs(Preferences contentTypeNode, int type) {
        String key = ContentType.getPreferenceKey(type);
        String existing = contentTypeNode.get(key, null);
        return Util.parseItems(existing);
    }

    public static String internalGetDefaultProperty(ContentType current, Preferences contentTypePrefs, QualifiedName key) throws BackingStoreException {
        Preferences contentTypeNode;
        String propertyValue;
        String id = current.getId();
        if (contentTypePrefs.nodeExists(id) && (propertyValue = (contentTypeNode = contentTypePrefs.node(id)).get(key.getLocalName(), null)) != null) {
            return propertyValue;
        }
        String propertyValue2 = current.basicGetDefaultProperty(key);
        if (propertyValue2 != null) {
            return propertyValue2;
        }
        ContentType baseType = (ContentType)current.getBaseType();
        return baseType == null ? null : ContentTypeSettings.internalGetDefaultProperty(baseType, contentTypePrefs, key);
    }

    static void removeFileSpec(IScopeContext context, String contentTypeId, String fileSpec, int type) throws CoreException {
        String key;
        Preferences contentTypeNode = ContentTypeManager.getInstance().getPreferences(context).node(contentTypeId);
        String existing = contentTypeNode.get(key = ContentType.getPreferenceKey(type), null);
        if (existing == null) {
            return;
        }
        List<String> existingValues = Util.parseItemsIntoList(contentTypeNode.get(key, null));
        int index = -1;
        int existingCount = existingValues.size();
        int i2 = 0;
        while (index == -1 && i2 < existingCount) {
            if (existingValues.get(i2).equalsIgnoreCase(fileSpec)) {
                index = i2;
            }
            ++i2;
        }
        if (index == -1) {
            return;
        }
        existingValues.remove(index);
        String newValue = Util.toListString(existingValues.toArray());
        ContentType.setPreference(contentTypeNode, key, newValue);
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = NLS.bind(ContentMessages.content_errorSavingSettings, contentTypeId);
            Status status = new Status(4, "paper.libs.org.eclipse.core.contenttype", 0, message, (Throwable)bse);
            throw new CoreException(status);
        }
    }

    public ContentTypeSettings(ContentType contentType, IScopeContext context) {
        this.context = context;
        this.contentType = contentType;
    }

    @Override
    public void addFileSpec(String fileSpec, int type) throws CoreException {
        ContentTypeSettings.addFileSpec(this.context, this.contentType.getId(), fileSpec, type);
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String getDefaultCharset() {
        return this.getDefaultProperty(IContentDescription.CHARSET);
    }

    @Override
    public String getDefaultProperty(QualifiedName key) {
        IEclipsePreferences contentTypePrefs = ContentTypeManager.getInstance().getPreferences(this.context);
        try {
            String propertyValue = ContentTypeSettings.internalGetDefaultProperty(this.contentType, contentTypePrefs, key);
            return "".equals(propertyValue) ? null : propertyValue;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    @Override
    public String[] getFileSpecs(int type) {
        return ContentTypeSettings.getFileSpecs(this.context, this.contentType.getId(), type);
    }

    @Override
    public String getId() {
        return this.contentType.getId();
    }

    @Override
    public void removeFileSpec(String fileSpec, int type) throws CoreException {
        ContentTypeSettings.removeFileSpec(this.context, this.contentType.getId(), fileSpec, type);
    }

    @Override
    public void setDefaultCharset(String userCharset) throws CoreException {
        Preferences contentTypeNode = ContentTypeManager.getInstance().getPreferences(this.context).node(this.contentType.getId());
        ContentType.setPreference(contentTypeNode, "charset", userCharset);
        try {
            contentTypeNode.flush();
        }
        catch (BackingStoreException bse) {
            String message = NLS.bind(ContentMessages.content_errorSavingSettings, this.contentType.getId());
            Status status = new Status(4, "paper.libs.org.eclipse.core.contenttype", 0, message, (Throwable)bse);
            throw new CoreException(status);
        }
    }

    @Override
    public boolean isUserDefined() {
        return this.getContentType().isUserDefined();
    }
}

